<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Expedux\OrdersJoinsEmail\Block\Adminhtml\Template;

/**
 * Email template preview block.
 *
 * @api
 * @since 100.0.2
 */
class MultiPreview extends \Magento\Backend\Block\Widget
{
    /**
     * @var \Magento\Framework\Filter\Input\MaliciousCode
     */
    protected $_maliciousCode;

    /**
     * @var \Magento\Email\Model\TemplateFactory
     */
    protected $_emailFactory;

    /**
     * @var string
     */
    protected $profilerName = 'email_template_proccessing';

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode
     * @param \Magento\Email\Model\TemplateFactory $emailFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode,
        \Magento\Email\Model\TemplateFactory $emailFactory,
        \Magento\Customer\Model\Customer $customer,
        \Magento\Catalog\Model\Product $product,
        \Magento\Sales\Model\Order $order,
        \Magento\Directory\Model\Region $regionModel,
        \Magento\Directory\Model\Country $countryModel,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        array $data = []
    ) {
        $this->_maliciousCode = $maliciousCode;
        $this->_emailFactory = $emailFactory;
        $this->_customer = $customer;
        $this->_product = $product;
        $this->_order = $order;
        $this->_regionModel = $regionModel;
        $this->_countryModel = $countryModel;
        $this->orderAddressDelegate = $orderAddressDelegate;
        parent::__construct($context, $data);
    }

    /**
     * Prepare html output
     *
     * @return string
     * @throws \Exception
     */
    protected function _toHtml()
    {
        $request = $this->getRequest();

        $storeId = $this->getAnyStoreView()->getId();
        /** @var $template \Magento\Email\Model\Template */
        $template = $this->_emailFactory->create();


          $store = $this->_storeManager->getStore()->getId();
            $orderId = $request->getParam('orderId');
            $deleIds = $this->getRequest()->getParam('delegate_ids');

        
            if (! empty ( $deleIds )) {
    			$deleArry = explode ( ",", $deleIds );
                $delegId = $deleArry[0];
                $orderAddressDelegateRow = $this->orderAddressDelegate->create()->getCollection()
                ->addFieldToFilter('entity_id', $delegId)
                ->addFieldToFilter('order_id', $orderId)->toArray();
                $addressRow = $orderAddressDelegateRow['items'][0];
                $productId = $addressRow['product_id'];
    			$customer_address_id = $addressRow['customer_address_id'];


            }else{
                $orderAddressDelegateRow = $this->orderAddressDelegate->create()->getCollection()
                ->addFieldToFilter('order_id', $orderId)->getFirstItem()->toArray();
                $addressRow = $orderAddressDelegateRow;
                $productId = $addressRow['product_id'];
    			$customer_address_id = $addressRow['customer_address_id'];
            }
          
            $order = $this->_order->load($orderId);
            //$shiperemail = $order->getShippingAddress()->getDelegateEmail();


            $coursedate = "";
    		$coursevenue = "";
            $prod = $this->_product->load($productId);
            
            if(!empty($prod->getData('dates'))){
                $coursedate = $prod->getAttributeText('dates');
                }else{
                    $coursedate = "";  
                }


                if(!empty($prod->getData('venue'))){
                    $coursevenue = $prod->getAttributeText('venue');
                }else{
                    $coursevenue = "";  
                }


          
          $customer = $this->_customer->load($order->getCustomerId());
          $customer_email = $customer->getEmail();
         
              
                  if(!empty($customer_address_id))
                  {
                     
                      $firstname = $addressRow['firstname'];
                      $lastname = $addressRow['lastname'];
                      $street = $addressRow['street'];
                      $region = $addressRow ['region'];
                      $city = $addressRow ['city'];
                      $postcode = $addressRow ['postcode'];
                      $country = $addressRow ['country_id'];
                      $email = $addressRow ['delegate_email'];
                      $countryName = "";
                      if(!empty($country)){
                      $countryModel = $this->_countryModel->load($country);
                      $countryName = $countryModel->getName();
                      }
    
                  }
                  else  
                  {     if($customer->getFirstname()){
                            $firstname = $customer->getFirstname();
                            $lastname = $customer->getLastname();
                        }else{
                            $firstname = $addressRow['firstname'];
                            $lastname = $addressRow['lastname'];
                        }
                      
                      $email = $customer_email;
                      $street = implode("\n", $order->getShippingAddress()->getStreet());
                      $region = $order->getShippingAddress()->getRegion();
                      $city = $order->getShippingAddress()->getCity();
                      $postcode = $order->getShippingAddress()->getPostcode();
                      $country = $order->getShippingAddress()->getCountryId();  	
                          $countryName = "";
                      if(!empty($country)){
                      $countryModel = $this->_countryModel->load($country);
                      $countryName = $countryModel->getName();
                      }		
                  } 

                
                
                
                  $vars = [
                          'name' => $firstname.' '.$lastname,
                          'firstname' => $firstname,
                          'lastname' => $lastname,
                          'coursedate' => $coursedate,
                          'coursevenue' => $coursevenue,
                          'street' => $street,
                          'region' => $region,
                          'city' => $city,
                          'postcode' => $postcode,
                          'country' => $countryName,
                          'createdate' => date('d F Y')
                            ];

        $template->load($request->getParam('templateId'));
        $template->setTemplateText($request->getParam('template_text'));
        \Magento\Framework\Profiler::start($this->profilerName);
        $template->getProcessedTemplate($vars);
        $template->emulateDesign($storeId);
        $templateProcessed = $this->_appState->emulateAreaCode(
            \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
            [$template, 'getProcessedTemplate']
        );
        $template->revertDesign();
        $templateProcessed = $this->_maliciousCode->filter($templateProcessed);

        if ($template->isPlain()) {
            $templateProcessed = "<pre>" . $this->escapeHtml($templateProcessed) . "</pre>";
        }

        \Magento\Framework\Profiler::stop($this->profilerName);
        
        return $templateProcessed;
    }

    /**
     * Get either default or any store view
     *
     * @return \Magento\Store\Model\Store|null
     */
    protected function getAnyStoreView()
    {
        $store = $this->_storeManager->getDefaultStoreView();
        if ($store) {
            return $store;
        }
        foreach ($this->_storeManager->getStores() as $store) {
            return $store;
        }
        return null;
    }
}
