<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Expedux\OrdersJoinsEmail\Block\Adminhtml\Template;

/**
 * Email template preview block.
 *
 * @api
 * @since 100.0.2
 */
class Preview extends \Magento\Backend\Block\Widget
{
    /**
     * @var \Magento\Framework\Filter\Input\MaliciousCode
     */
    protected $_maliciousCode;

    /**
     * @var \Magento\Email\Model\TemplateFactory
     */
    protected $_emailFactory;

    /**
     * @var string
     */
    protected $profilerName = 'email_template_proccessing';

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode
     * @param \Magento\Email\Model\TemplateFactory $emailFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode,
        \Magento\Email\Model\TemplateFactory $emailFactory,
        \Magento\Customer\Model\Customer $customer,
        \Magento\Catalog\Model\Product $product,
        \Magento\Sales\Model\Order $order,
        \Magento\Directory\Model\Region $regionModel,
        \Magento\Directory\Model\Country $countryModel,
        array $data = []
    ) {
        $this->_maliciousCode = $maliciousCode;
        $this->_emailFactory = $emailFactory;
        $this->_customer = $customer;
        $this->_product = $product;
        $this->_order = $order;
        $this->_regionModel = $regionModel;
        $this->_countryModel = $countryModel;
        parent::__construct($context, $data);
    }

    /**
     * Prepare html output
     *
     * @return string
     * @throws \Exception
     */
    protected function _toHtml()
    {
        $request = $this->getRequest();
//print_r($request->getParams());exit();
        $storeId = $this->getAnyStoreView()->getId();
        /** @var $template \Magento\Email\Model\Template */
        $template = $this->_emailFactory->create();

        // if ($id = (int)$request->getParam('id')) {
        //     $template->load($id);
        // } else {
        //     $template->setTemplateType($request->getParam('type'));
        //     $template->setTemplateText($request->getParam('text'));
        //     $template->setTemplateStyles($request->getParam('styles'));
        //     $template->setData('is_legacy', false);
        // }

          $store = $this->_storeManager->getStore()->getId();
            $orderId = $request->getParam('orderId');
          $templateId = $request->getParam('templateId');
          $order = $this->_order->load($orderId);
          $customer = $this->_customer->load($order->getCustomerId());
          $customer_email = $customer->getEmail();
         
              $shiperemail = $order->getShippingAddress()->getDelegateEmail();
              $items = $order->getAllItems();
              $data = [];
              $i=0;
              foreach ($items as $itemId => $item)
              {
                    $prod = $this->_product->load($item->getProductId());
                  if(!empty($prod->getData('dates'))){
                  $data[$i]['coursedate'] = $prod->getAttributeText('dates');
                  }else{
                    $data[$i]['coursedate'] = "";  
                  }
                  if(!empty($prod->getData('venue'))){
                  $data[$i]['coursevenue'] = $prod->getAttributeText('venue');
                  }else{
                    $data[$i]['coursevenue'] = "";  
                  }
              }	
              
              if(count($data)>0)
              {
                  $coursedate = $data[0]['coursedate'];
                  $coursevenue = $data[0]['coursevenue'];
              }
              else
              {
                  $coursedate = "";
                  $coursevenue = "";
              }	
                  if(!empty($shiperemail))
                  {
                      if($shiperemail != $customer_email){
                      $firstname = $order->getShippingAddress()->getFirstname();
                      $lastname = $order->getShippingAddress()->getLastname();
                      $street = implode("\n", $order->getShippingAddress()->getStreet());
                      $region = $order->getShippingAddress()->getRegion();
                      $city = $order->getShippingAddress()->getCity();
                      $postcode = $order->getShippingAddress()->getPostcode();
                      $country = $order->getShippingAddress()->getCountryId();
                      $email = $shiperemail;
                      $countryName = "";
                      if(!empty($country)){
                      $countryModel = $this->_countryModel->load($country);
                      $countryName = $countryModel->getName();
                      }
                      }
                      else
                      {
                      $firstname = $order->getShippingAddress()->getFirstname();
                      $lastname = $order->getShippingAddress()->getLastname();
                      $street = implode("\n", $order->getShippingAddress()->getStreet());
                      $region = $order->getShippingAddress()->getRegion();
                      $city = $order->getShippingAddress()->getCity();
                      $postcode = $order->getShippingAddress()->getPostcode();
                      $country = $order->getShippingAddress()->getCountryId();  	
                          $email = $customer_email;
                      $countryName = "";
                      if(!empty($country)){
                      $countryModel = $this->_countryModel->load($country);
                      $countryName = $countryModel->getName();
                      }		
                      }
                      
                  }
                  else
                  {
                    if($customer->getFirstname()){
                        $firstname = $customer->getFirstname();
                        $lastname = $customer->getLastname();
                    }else{
                        $firstname = $addressRow['firstname'];
                        $lastname = $addressRow['lastname'];
                    }
                      $email = $customer_email;
                      $street = implode("\n", $order->getShippingAddress()->getStreet());
                      $region = $order->getShippingAddress()->getRegion();
                      $city = $order->getShippingAddress()->getCity();
                      $postcode = $order->getShippingAddress()->getPostcode();
                      $country = $order->getShippingAddress()->getCountryId();  	
                          $countryName = "";
                      if(!empty($country)){
                      $countryModel = $this->_countryModel->load($country);
                      $countryName = $countryModel->getName();
                      }		
                  } 

                  // Set variables that can be used in email template
                  $vars = [
                          'name' => $firstname.' '.$lastname,
                          'firstname' => $firstname,
                          'lastname' => $lastname,
                          'coursedate' => $coursedate,
                          'coursevenue' => $coursevenue,
                          'street' => $street,
                          'region' => $region,
                          'city' => $city,
                          'postcode' => $postcode,
                          'country' => $countryName,
                          'createdate' => date('d F Y')
                            ];
                  
         
             
              

        $template->load($request->getParam('templateId'));
        $template->setTemplateText($request->getParam('template_text'));
        \Magento\Framework\Profiler::start($this->profilerName);
        $template->getProcessedTemplate($vars);
        $template->emulateDesign($storeId);
        $templateProcessed = $this->_appState->emulateAreaCode(
            \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
            [$template, 'getProcessedTemplate']
        );
        $template->revertDesign();
        $templateProcessed = $this->_maliciousCode->filter($templateProcessed);

        if ($template->isPlain()) {
            $templateProcessed = "<pre>" . $this->escapeHtml($templateProcessed) . "</pre>";
        }

        \Magento\Framework\Profiler::stop($this->profilerName);
        
        return $templateProcessed;
    }

    /**
     * Get either default or any store view
     *
     * @return \Magento\Store\Model\Store|null
     */
    protected function getAnyStoreView()
    {
        $store = $this->_storeManager->getDefaultStoreView();
        if ($store) {
            return $store;
        }
        foreach ($this->_storeManager->getStores() as $store) {
            return $store;
        }
        return null;
    }
}
