<?php

namespace Expedux\OrdersJoinsEmail\Controller\Adminhtml\OrdersJoinsEmail;

use Magento\Backend\App\Action;

Class GeneratePdf extends Action
{
        public function __construct(
            \Magento\Backend\App\Action\Context $context,
            \Expedux\OrdersJoinsEmail\Model\OrderJoinsModel $orderJoinsModel,
            \Magento\Sales\Model\Order $order,
            \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
        ) {
            parent::__construct($context);
            $this->resultJsonFactory = $resultJsonFactory;
            $this->_orderJoinsModel = $orderJoinsModel;
            $this->_order = $order;
        }

        public function execute()
        {

            $pdfTemplates = $this->getRequest()->getParam('pdfTemplate');
            foreach($pdfTemplates as $pdfTemplate){
                $order =$this->_order->load($pdfTemplate['orderId']);
                $templateProcessed = $pdfTemplate['templateProcessed'];
                $recepientEmail = $pdfTemplate['recepientEmail'];
                $templateSubject = $pdfTemplate['templateSubject'];
                $multideligate = $this->getRequest()->getParam('multideligate');

                $this->_orderJoinsModel->joinsLetterPdf($order,$templateProcessed,$recepientEmail,$templateSubject,$multideligate);
            }
            $output['mstatus'] = 200;
            $result = $this->resultJsonFactory->create();
            return $result->setData($output);
       
        }


}