<?php

namespace Expedux\OrdersJoinsEmail\Controller\Adminhtml\OrdersJoinsEmail;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\DataObject;
use Zend\Mail\Transport\Exception as TransportException;

use Zend\Mail\Message;
use Zend\Mail\Transport\Smtp as SmtpTransport;
use Zend\Mail\Transport\SmtpOptions;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

use Magento\Backend\App\Action;

Class SendJoins extends \Magento\Backend\App\Action implements HttpPostActionInterface
{
    protected $profilerName = 'email_template_proccessing';

        public function __construct(
            \Magento\Backend\App\Action\Context $context,
            \Magento\Email\Model\TemplateFactory $templateFactory,
            \Magento\Store\Model\StoreManager $storeManager,
            \Magento\Customer\Model\Customer $customer,
            \Magento\Catalog\Model\Product $product,
            \Magento\Sales\Model\Order $order,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory,
            \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
            \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode,
            \Magento\Framework\App\State $appState,
            \Magento\Directory\Model\CountryFactory $countryFactory,
            \Expedux\OrdersJoinsEmail\Model\OrderJoinsModel $orderJoinsModel,
            \Magento\Framework\Controller\Result\RawFactory $resultRawFactory,
            ScopeConfigInterface $scopeConfig,
            \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
        ) {
            parent::__construct($context);
            $this->_templateFactory = $templateFactory;
            $this->_storeManager = $storeManager;
            $this->_customer = $customer;
            $this->_product = $product;
            $this->_order = $order;
            $this->_resultPageFactory = $resultPageFactory;
            $this->_transportBuilder = $transportBuilder;
            $this->_appState = $appState;
            $this->_maliciousCode = $maliciousCode;
            $this->_countryFactory = $countryFactory;
            $this->_resultJsonFactory = $resultJsonFactory;
            $this->resultRawFactory      = $resultRawFactory;
            $this->scopeConfig = $scopeConfig;
            $this->_orderJoinsModel = $orderJoinsModel;
        }

        public function execute()
        {

            if($this->getRequest()->getParam('orderId') && $this->getRequest()->getParam('templatesId'))
            {
            // Get Store ID		
            $store = $this->_storeManager->getStore()->getId();		
            $orderId = $this->getRequest()->getParam('orderId');
            $order =$this->_order->load($orderId);
                    
                $customer = $this->_customer->load($order->getCustomerId());
                $customer_email = $customer->getEmail();
                $shiperemail = $order->getShippingAddress()->getDelegateEmail();
                $items = $order->getAllItems();
            $data = array();
            $i=0;
            foreach ($items as $itemId => $item)
            {
                  $prod = $this->_product->load($item->getProductId());
                if(!empty($prod->getData('dates'))){
                $data[$i]['coursedate'] = $prod->getAttributeText('dates');
                }
                if(!empty($prod->getData('dates'))){
                $data[$i]['coursevenue'] = $prod->getAttributeText('venue');
                }
            }	
            if(count($data)>0)
            {
                $coursedate = $data[0]['coursedate'];
                $coursevenue = $data[0]['coursevenue'];
            }
            else
            {
                $coursedate = "";
                $coursevenue = "";
            }	
                if(!empty($shiperemail))
                {
                    if($shiperemail != $customer_email){
                        $firstname = $order->getShippingAddress()->getFirstname();
                        $lastname = $order->getShippingAddress()->getLastname();
                    $street = $order->getShippingAddress()->getStreetFull();
                    $region = $order->getShippingAddress()->getRegion();
                    $city = $order->getShippingAddress()->getCity();
                    $postcode = $order->getShippingAddress()->getPostcode();
                    $country = $order->getShippingAddress()->getCountryId();
                        $email = $shiperemail;
                    $countryName = "";
                    if(!empty($country)){
                    $country = $this->_countryFactory->create()->loadByCode($country);
                    $countryName = $country->getName();
                    }
                    }
                    else
                    {
                        $firstname = $order->getShippingAddress()->getFirstname();
                        $lastname = $order->getShippingAddress()->getLastname();
                    $street = $order->getShippingAddress()->getStreetFull();
                    $region = $order->getShippingAddress()->getRegion();
                    $city = $order->getShippingAddress()->getCity();
                    $postcode = $order->getShippingAddress()->getPostcode();
                    $country = $order->getShippingAddress()->getCountryId();  	
                        $email = $customer_email;
                    $countryName = "";
                    if(!empty($country)){
                        $country = $this->_countryFactory->create()->loadByCode($country);
                        $countryName = $country->getName();
                    }		
                    }
                    
                }
                else
                {
                    $firstname = $customer->getFirstname();
                    $lastname = $customer->getLastname();
                    $email = $customer_email;
                    $street = $order->getShippingAddress()->getStreetFull();
                    $region = $order->getShippingAddress()->getRegion();
                    $city = $order->getShippingAddress()->getCity();
                    $postcode = $order->getShippingAddress()->getPostcode();
                    $country = $order->getShippingAddress()->getCountryId();  	
                        $countryName = "";
                        if(!empty($country)){
                            $country = $this->_countryFactory->create()->loadByCode($country);
                            $countryName = $country->getName();
                        }			
                }  
               
            $templateId = $this->getRequest()->getParam('templatesId');
     
            // Set sender information			
           
            
            $senderEmail = $this->scopeConfig->getValue('trans_email/ident_support/email',ScopeInterface::SCOPE_STORE);
            $senderName  = $this->scopeConfig->getValue('trans_email/ident_support/name',ScopeInterface::SCOPE_STORE);
            

            $sender = array('name' => $senderName,
                    'email' => $senderEmail);
        
            // Set recepient information
            $recepientEmail = $email;
            $recepientName = $firstname.' '.$lastname;		
        
            
         
            // Set variables that can be used in email template
            $vars = array('name' => $firstname.' '.$lastname,
                      'firstname' => $firstname,
                      'lastname' => $lastname,
                      'coursedate' => $coursedate,		
                      'coursevenue' => $coursevenue,
                      'street' => $street,
                      'region' => $region,
                      'city' => $city,
                      'postcode' => $postcode,
                      'country' => $countryName,
                      'createdate' => date('d F Y'));
             
            
            $template = $this->_templateFactory->create()->load($templateId);
            \Magento\Framework\Profiler::start($this->profilerName);
            
            $template->revertDesign();
            $templateProcessed = $this->_appState->emulateAreaCode(
                \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
                [$template, 'getProcessedTemplate']
            );
            $template->setTemplateText(
                $this->_maliciousCode->filter($this->getRequest()->getParam('template_text'))
            );

            $templateProcessed = $this->_maliciousCode->filter($templateProcessed);
            $templateProcessed = $template->getProcessedTemplate($vars, true);
            \Magento\Framework\Profiler::stop($this->profilerName);
            
            $templateSubject = $this->getRequest()->getParam('template_subject');

            $vars['body'] = $templateProcessed;
            $vars['subject'] = $templateSubject;


            $store = $this->_storeManager->getStore()->getId();

            $recipient[] = [$senderEmail,$senderName];
            $recipient[] = [$recepientEmail,$recepientName]; 
            $transport = $this->_transportBuilder->setTemplateIdentifier('exambookings_joinsletter_email_template')
                ->setTemplateOptions(['area' => 'frontend', 'store' => $store])
                ->setTemplateVars(
            [
                'store' => $this->_storeManager->getStore(),
                'data' => new DataObject($vars)
            ]
            )->setFrom('general');
        

            foreach ($recipient as $recip) {
                $this->_transportBuilder->addTo($recip[0], $recip[1]);
            }
        
            $this->_transportBuilder->getTransport()->sendMessage();


            $template = $this->_templateFactory->create()->load($templateId);
            \Magento\Framework\Profiler::start($this->profilerName);
            
            $template->revertDesign();
            $templateProcessed = $this->_appState->emulateAreaCode(
                \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
                [$template, 'getProcessedTemplate']
            );
            
            $template_text_pdf=$this->getRequest()->getParam('template_text');
            $template_text_pdf=str_replace('{{template config_path="design/email/header_template"}}','',$template_text_pdf);
            $template_text_pdf=str_replace('{{template config_path="design/email/footer_template"}}','',$template_text_pdf);
            
            $template->setTemplateText(
                $this->_maliciousCode->filter($template_text_pdf)
            );

            $templateProcessed = $this->_maliciousCode->filter($templateProcessed);
            $templateProcessed = $template->getProcessedTemplate($vars, true);
            \Magento\Framework\Profiler::stop($this->profilerName);


           // $this->_orderJoinsModel->joinsLetterPdf($order,$templateProcessed,$recepientEmail,$templateSubject);
            $output['mstatus'] = 200;
         
            $pdfTemplate[] = [
                'orderId' => $orderId,
                'templateProcessed' => $templateProcessed,
                'recepientEmail' => $recepientEmail,
                'templateSubject' => $templateSubject,
            ];

            $output['pdfTemplate'] = $pdfTemplate;

              //echo "das";exit();    
                        //to customer
                        // $result = $this->_resultJsonFactory->create();
              
                        // return $result->setData($output);

            // $json = json_encode($output);        
            // header('Content-Type: application/json');
            // echo $json;

            $result = $this->_resultJsonFactory->create();
            return $result->setData($output);
        } 
       
    }
}