<?php

namespace Expedux\OrdersJoinsEmail\Controller\Adminhtml\OrdersJoinsEmail;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\DataObject;
use Zend\Mail\Transport\Exception as TransportException;

use Zend\Mail\Message;
use Zend\Mail\Transport\Smtp as SmtpTransport;
use Zend\Mail\Transport\SmtpOptions;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

use Magento\Backend\App\Action;

Class SendMultiJoins extends \Magento\Backend\App\Action implements HttpPostActionInterface
{
    protected $profilerName = 'email_template_proccessing';

        public function __construct(
            \Magento\Backend\App\Action\Context $context,
            \Magento\Email\Model\TemplateFactory $templateFactory,
            \Magento\Store\Model\StoreManager $storeManager,
            \Magento\Customer\Model\Customer $customer,
            \Magento\Catalog\Model\Product $product,
            \Magento\Sales\Model\Order $order,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory,
            \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
            \Magento\Framework\Filter\Input\MaliciousCode $maliciousCode,
            \Magento\Framework\App\State $appState,
            \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
            \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
            \Magento\Directory\Model\CountryFactory $countryFactory,
            ScopeConfigInterface $scopeConfig,
            \Expedux\OrdersJoinsEmail\Model\OrderJoinsModel $orderJoinsModel
        ) {
            parent::__construct($context);
            $this->_templateFactory = $templateFactory;
            $this->_storeManager = $storeManager;
            $this->_customer = $customer;
            $this->_product = $product;
            $this->_order = $order;
            $this->_resultPageFactory = $resultPageFactory;
            $this->_transportBuilder = $transportBuilder;
            $this->_appState = $appState;
            $this->_maliciousCode = $maliciousCode;
            $this->orderAddressDelegate = $orderAddressDelegate;
            $this->_resultJsonFactory = $resultJsonFactory;
            $this->_countryFactory = $countryFactory;
            $this->scopeConfig = $scopeConfig;
            $this->_orderJoinsModel = $orderJoinsModel;
        }

        public function execute()
        {
            if($this->getRequest()->getParam('orderId') && $this->getRequest()->getParam('templatesId'))
            {
            // Get Store ID		
            $store = $this->_storeManager->getStore()->getId();		
            $orderId = $this->getRequest()->getParam('orderId');
            $deleIds = $this->getRequest ()->getParam ('deleIds');
            $order =$this->_order->load($orderId);
               
         
                $customer = $this->_customer->load($order->getCustomerId());
                $customer_email = $customer->getEmail();
                //$shiperemail = $order->getShippingAddress()->getDelegateEmail();
                $deleArry = [];
            if (! empty ( $deleIds )) {
				$deleArry = explode ( ",", $deleIds );
			} else {
                    $orderAddressDelegate = $this->orderAddressDelegate->create()->getCollection()
                                        //->addFieldToFilter('is_join_send', 0)
                                        ->addFieldToFilter('order_id', $orderId);

				if (count ( $orderAddressDelegate->getData() ) > 0) {
					foreach ( $orderAddressDelegate->getData() as $add ) {
						$deleArry [] = $add ['entity_id'];
					}
				}
            }
            //echo "<pre>";print_r($deleArry);exit;
            if (count ( $deleArry ) > 0) {
              foreach ( $deleArry as $add ) {
                $addressArr = $this->orderAddressDelegate->create()->getCollection()
                ->addFieldToFilter('entity_id', $add)
                ->addFieldToFilter('order_id', $orderId)->toArray();

                if (count ( $addressArr['items'] ) > 0) {
                    $addRow = $addressArr['items'][0];
                    if (! empty ( $addRow ['customer_address_id'] )) {
                        
                        $firstname = $addRow ['firstname'];
                        $lastname = $addRow ['lastname'];
                        $street = $addRow ['street'];
                        $region = $addRow ['region'];
                        $city = $addRow ['city'];
                        $postcode = $addRow ['postcode'];
                        $country = $addRow ['country_id'];
                        $email = $addRow ['delegate_email'];
                        $countryName = "";
                        if(!empty($country)){
                            $country = $this->_countryFactory->create()->loadByCode($country);
                            $countryName = $country->getName();
                        }	
                    } else {
                        $firstname = $order->getShippingAddress ()->getFirstname ();
                        $lastname = $order->getShippingAddress ()->getLastname ();
                        $street = $order->getShippingAddress ()->getStreetFull ();
                        $region = $order->getShippingAddress ()->getRegion ();
                        $city = $order->getShippingAddress ()->getCity ();
                        $postcode = $order->getShippingAddress ()->getPostcode ();
                        $country = $order->getShippingAddress ()->getCountryId ();
                        $shiperemail = $order->getShippingAddress()->getDelegateEmail();
                        $email = $shiperemail;                        
                        if(empty($email)){
                            $email = $customer_email;
                        }
                        
                        $countryName = "";
                        if(!empty($country)){
                            $country = $this->_countryFactory->create()->loadByCode($country);
                            $countryName = $country->getName();
                        }	
                    }
                    
                    $coursedate = "";
                    $coursevenue = "";
                    $prod = $this->_product->load ( $addRow ['product_id'] );
                    
                    if (! empty ( $prod->getData ( 'dates' ) )) {
                        $coursedate = $prod->getAttributeText ( 'dates' );
                    }
                    if (! empty ( $prod->getData ( 'dates' ) )) {
                        $coursevenue = $prod->getAttributeText ( 'venue' );
                    }
                    
                    $templateId = $this->getRequest ()->getParam ( 'templatesId' );
                    
                    // Set sender information

                    $senderEmail = $this->scopeConfig->getValue('trans_email/ident_support/email',ScopeInterface::SCOPE_STORE);
					$senderName  = $this->scopeConfig->getValue('trans_email/ident_support/name',ScopeInterface::SCOPE_STORE);
                    
                    $sender = array (
                            'name' => $senderName,
                            'email' => $senderEmail 
                    );
                    
                    // Set recepient information
                    $recepientEmail = $email;
                    $recepientName = $firstname . ' ' . $lastname;
                    
                    // Set variables that can be used in email template
                    $vars = array (
                            'name' => $firstname . ' ' . $lastname,
                            'firstname' => $firstname,
                            'lastname' => $lastname,
                            'coursedate' => $coursedate,
                            'coursevenue' => $coursevenue,
                            'street' => $street,
                            'region' => $region,
                            'city' => $city,
                            'postcode' => $postcode,
                            'country' => $countryName,
                            'createdate' => date ( 'd F Y' ) 
                    );
                    
                    $template = $this->_templateFactory->create()->load($templateId);
                    \Magento\Framework\Profiler::start($this->profilerName);
                    // $template->setTemplateText($this->getRequest()->getParam('template_text'));
                    $template->revertDesign();
                    $templateProcessed = $this->_appState->emulateAreaCode(
                        \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
                        [$template, 'getProcessedTemplate']
                    );

                    $template_text_pdf=$this->getRequest()->getParam('template_text');
	
                    
                    $template->setTemplateText(
                        $this->_maliciousCode->filter($template_text_pdf)
                    );
        
                   // 
                   $templateProcessed = $this->_maliciousCode->filter($templateProcessed);
                   $templateProcessed = $template->getProcessedTemplate($vars, true);

                   \Magento\Framework\Profiler::stop($this->profilerName);
                    
                
       
                    $vars['body'] = $templateProcessed;
                    $vars['subject'] = $this->getRequest()->getParam('template_subject');
                    
                    
                                $store = $this->_storeManager->getStore()->getId();
                                $recipient = [];
                                $recipient[] = [$senderEmail,$senderName];
                                $recipient[] = [$recepientEmail,$recepientName]; 
                                $transport = $this->_transportBuilder->setTemplateIdentifier('exambookings_joinsletter_email_template')
                            ->setTemplateOptions(['area' => 'frontend', 'store' => $store])
                            ->setTemplateVars(
                                [
                                    'store' => $this->_storeManager->getStore(),
                                    'data' => new DataObject($vars)
                                ]
                            )->setFrom('general');
                            
                            foreach ($recipient as $recip) {
                                $this->_transportBuilder->addTo($recip[0], $recip[1]);
                            }
                            
                            $this->_transportBuilder->getTransport()->sendMessage();
                    
                   
                    //for PDF
    
                    $template = $this->_templateFactory->create()->load($templateId);
                    \Magento\Framework\Profiler::start($this->profilerName);
                
                    $template->revertDesign();
                    $templateProcessed = $this->_appState->emulateAreaCode(
                        \Magento\Email\Model\AbstractTemplate::DEFAULT_DESIGN_AREA,
                        [$template, 'getProcessedTemplate']
                    );

                    $template_text_pdf=$this->getRequest()->getParam('template_text');
					$template_text_pdf=str_replace('{{template config_path="design/email/header_template"}}','',$template_text_pdf);
                    $template_text_pdf=str_replace('{{template config_path="design/email/footer_template"}}','',$template_text_pdf);
                    
                    $template->setTemplateText(
                        $this->_maliciousCode->filter($template_text_pdf)
                    );
        
                   $templateProcessed = $this->_maliciousCode->filter($templateProcessed);
                   $templateProcessed = $template->getProcessedTemplate($vars, true);

                   \Magento\Framework\Profiler::stop($this->profilerName);
                 
                   $templateSubject = $this->getRequest()->getParam('template_subject');
                  // $this->_orderJoinsModel->joinsLetterPdf($order,$templateProcessed,$recepientEmail,$templateSubject);
                
                   $pdfTemplate[] = [
                       'orderId' => $orderId,
                       'templateProcessed' => $templateProcessed,
                       'recepientEmail' => $recepientEmail,
                       'templateSubject' => $templateSubject,
                   ];
                   $this->orderAddressDelegate->create()->load($addRow['entity_id'])->setIsJoinSend(1)->save();
                    
                }
            }


            $alldelgates = $this->orderAddressDelegate->create()->getCollection()
            ->addFieldToFilter('order_id', $orderId);

            $out_str = '';
            if (count ( $alldelgates->getData() ) > 0) {
                
                foreach ( $alldelgates->getData() as $deleg ) {
                    $prod =  $this->_product->load ( $deleg ['product_id'] );
                    $out_str .='<tr>
                    <td style="padding-bottom:10px;width:25%;">';
                    
                    $shiperemail = $deleg['delegate_email'];
                    $shipfirstname = $deleg ['firstname'];
                    $shiplastname = $deleg ['lastname'];
                    if(empty($deleg ['customer_address_id'])){
                        $shipfirstname = $order->getShippingAddress()->getFirstname();
                        $shiplastname = $order->getShippingAddress()->getLastname();
                        $shiperemail = $order->getShippingAddress()->getDelegateEmail();
                    }

                    $out_str .='<input type="checkbox" id="dele_id'.$deleg['entity_id'].'" class="admin__control-checkbox" name="dele_id" value="'.$deleg['entity_id'].'">';
                    $out_str .='<label class="admin__field-label" for="dele_id'.$deleg ['entity_id'].'">'.$shipfirstname." ".$shiplastname.'</label>';
                                  
                    

                    $out_str .='</td>
                                <td style="padding-bottom:10px;width:25%;">
                                '.$shiperemail.'
                                </td>
                                <td style="padding-bottom:10px;width:25%;">'.$prod->getSku().'</td>
                                <td style="padding-bottom:10px;width:25%;">';
                                if($deleg ['is_join_send']){
                                $out_str .='<strong class="subdue">Sent</strong>';
                                }
                                else{
                                    $out_str .='';
                                }
                                $out_str .='</td>
                                        </tr>';
                }					
            }				
            $output['deledetails'] = $out_str;
            $output['mstatus'] = 200;
            $output['pdfTemplate'] = $pdfTemplate;
        }

        $output['mstatus'] = 200;
        $result = $this->_resultJsonFactory->create();
        return $result->setData($output);

        } 
       
    }
}