<?php

namespace Expedux\OrdersJoinsEmail\Model;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DataObject;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Filesystem\DirectoryList;


class OrderJoinsModel
{
    public function __construct(
        \Magento\Sales\Model\Order $order,
        ResourceConnection $resource,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Catalog\Model\Product $product,
        ScopeConfigInterface $scopeConfig,
        \Eadesigndev\Pdfgenerator\Model\PdfgeneratorRepository $pdfgeneratorRepository,
        \Eadesigndev\Pdfgenerator\Helper\PdfJoins $pdfHelper,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Expedux\OrdersJoinsEmail\App\Response\Http\FileFactory $expFileFactory,
        \Magento\Framework\Math\Random $mathRandom,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\Filesystem\Io\File $fileIO,
        \Magento\Framework\Filesystem\Driver\File $file,
        \Magento\Backend\Model\Auth\Session $authSession
) {
        $this->_order = $order;
        $this->_resource = $resource;
        $this->_storeManager=$storeManager;
        $this->_transportBuilder = $transportBuilder;
        $this->_product = $product;
        $this->scopeConfig = $scopeConfig;
        $this->_pdfgeneratorRepository = $pdfgeneratorRepository;
        $this->_pdfHelper = $pdfHelper;
        $this->_fileFactory = $fileFactory;
        $this->_expFileFactory = $expFileFactory;
        $this->mathRandom = $mathRandom;
        $this->_filesystem = $filesystem;
        $this->_fileIO = $fileIO;
        $this->_file = $file;
        $this->authSession = $authSession;
}


    public function joinsLetterPdf($order,$templateProcessed,$recepientEmail,$templateSubject,$multiDelegate=false){
       
        

        $templateModel =  $this->_pdfgeneratorRepository->getById(3);

        $helper = $this->_pdfHelper;

        $helper->setOrder($templateProcessed);
        $helper->setTemplate($templateModel);

        $pdfFileData = $helper->template2Pdf();
       $randomString = $this->mathRandom->getRandomString(5);
        $fileName = 'send_joins_'.$randomString.'_'.date('Y-m-d_H-i-s').'.pdf';
       // 'pdf/'. $fileName,

        $this->_expFileFactory->create(
            'sendjoins/'. $fileName,
               $pdfFileData['filestream'],
               DirectoryList::MEDIA,
               'application/pdf'
           );

        $pdflink = $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA).'sendjoins/'.$fileName;
		$link_html ='<a href="'. $pdflink.'" target="_blank">Download</a>';
		
		$adminusername = $this->authSession->getUser()->getName();
		
		$lmscomments = "Joins Letter - ".date('Y-m-d H:i:s').". Joins letter sentout by ".$adminusername.' '.$link_html;
		$order->addStatusHistoryComment($lmscomments);
        $order->save();


        $connection = $this->_resource->getConnection();
        $select = 'SELECT entity_id FROM sales_order_status_history WHERE parent_id = '.$order->getId().' ORDER BY entity_id DESC LIMIT 1';
    
        $order_history_id = 0;

       if (count($connection->fetchAll($select)) > 0){
        $order_history_id = $connection->fetchAll($select)[0]['entity_id'];
       }

       if($multiDelegate == false)
		$parent_id=0;
		else
        $parent_id=$order->getCustomerId();
        
       
       $tblName = $this->_resource->getTableName('customer_letters');
       $sql = "INSERT INTO " . $tblName . "(order_id, customer_id,parent_id,order_history_id,email,subject,file_name) VALUES ('" . $order->getId() . "', '" . $order->getCustomerId() . "','" . $parent_id . "', '" . $order_history_id . "','".$recepientEmail."','".$templateSubject."','".$fileName."')";
        $connection->query($sql);
        
        return 1;
        
    }


}