<?php
/**
 *
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\OroIntegration\Controller\Subscriber;

use Magento\Customer\Api\AccountManagementInterface as CustomerAccountManagement;
use Magento\Customer\Model\Session;
use Magento\Customer\Model\Url as CustomerUrl;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;
use Magento\Framework\Validator\EmailAddress as EmailValidator;
use Magento\Newsletter\Controller\Subscriber as SubscriberController;
use Magento\Newsletter\Model\Subscriber;
use Magento\Newsletter\Model\SubscriptionManagerInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Newsletter\Model\SubscriberFactory;

/**
 * New newsletter subscription action
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class NewAction extends SubscriberController implements HttpPostActionInterface
{
    /**
     * @var CustomerAccountManagement
     */
    protected $customerAccountManagement;

    /**
     * @var EmailValidator
     */
    private $emailValidator;

    /**
     * @var SubscriptionManagerInterface
     */
    private $subscriptionManager;

    protected $_orourl = 'https://orocrm.spoce.com/api/';
    protected $_username = 'root';
    protected $_apiuserkey = '0a9b22da6266bd33d20056598e414e51a9afe0c2';
    /**
     * Initialize dependencies.
     *
     * @param Context $context
     * @param SubscriberFactory $subscriberFactory
     * @param Session $customerSession
     * @param StoreManagerInterface $storeManager
     * @param CustomerUrl $customerUrl
     * @param CustomerAccountManagement $customerAccountManagement
     * @param SubscriptionManagerInterface $subscriptionManager
     * @param EmailValidator $emailValidator
     */
    public function __construct(
        Context $context,
        SubscriberFactory $subscriberFactory,
        Session $customerSession,
        StoreManagerInterface $storeManager,
        CustomerUrl $customerUrl,
        CustomerAccountManagement $customerAccountManagement,
        SubscriptionManagerInterface $subscriptionManager,
        EmailValidator $emailValidator = null
    ) {
        $this->customerAccountManagement = $customerAccountManagement;
        $this->subscriptionManager = $subscriptionManager;
        $this->emailValidator = $emailValidator ?: ObjectManager::getInstance()->get(EmailValidator::class);
        parent::__construct(
            $context,
            $subscriberFactory,
            $customerSession,
            $storeManager,
            $customerUrl
        );
    }

    /**
     * Validates that the email address isn't being used by a different account.
     *
     * @param string $email
     * @throws LocalizedException
     * @return void
     */
    protected function validateEmailAvailable($email)
    {
        $websiteId = $this->_storeManager->getStore()->getWebsiteId();
        if ($this->_customerSession->isLoggedIn()
            && ($this->_customerSession->getCustomerDataObject()->getEmail() !== $email
            && !$this->customerAccountManagement->isEmailAvailable($email, $websiteId))
        ) {
            throw new LocalizedException(
                __('This email address is already assigned to another user.')
            );
        }
    }

    /**
     * Validates that if the current user is a guest, that they can subscribe to a newsletter.
     *
     * @throws LocalizedException
     * @return void
     */
    protected function validateGuestSubscription()
    {
        if ($this->_objectManager->get(ScopeConfigInterface::class)
                ->getValue(
                    Subscriber::XML_PATH_ALLOW_GUEST_SUBSCRIBE_FLAG,
                    ScopeInterface::SCOPE_STORE
                ) != 1
            && !$this->_customerSession->isLoggedIn()
        ) {
            throw new LocalizedException(
                __(
                    'Sorry, but the administrator denied subscription for guests. Please <a href="%1">register</a>.',
                    $this->_customerUrl->getRegisterUrl()
                )
            );
        }
    }

    /**
     * Validates the format of the email address
     *
     * @param string $email
     * @throws LocalizedException
     * @return void
     */
    protected function validateEmailFormat($email)
    {
        if (!$this->emailValidator->isValid($email)) {
            throw new LocalizedException(__('Please enter a valid email address.'));
        }
    }

    /**
     * New subscription action
     *
     * @return Redirect
     */
    public function execute()
    {
        if ($this->getRequest()->isPost() && $this->getRequest()->getPost('email')) {
            $email = (string)$this->getRequest()->getPost('email');
            $firstname = (string)$this->getRequest()->getPost('firstname');
            $lastname = (string)$this->getRequest()->getPost('lastname');
            try {
                $this->validateEmailFormat($email);
                $this->validateGuestSubscription();
                $this->validateEmailAvailable($email);

                $websiteId = (int)$this->_storeManager->getStore()->getWebsiteId();
                /** @var Subscriber $subscriber */
                $subscriber = $this->_subscriberFactory->create()->loadBySubscriberEmail($email, $websiteId);
               
                if ($subscriber->getId()
                    && (int)$subscriber->getSubscriberStatus() === Subscriber::STATUS_SUBSCRIBED) {
                    throw new LocalizedException(
                        __('This email address is already subscribed.')
                    );
                }
                
                $storeId = (int)$this->_storeManager->getStore()->getId();
                $currentCustomerId = $this->getSessionCustomerId($email);
                $subscriber = $currentCustomerId
                    ? $this->subscriptionManager->subscribeCustomer($currentCustomerId, $storeId)
                    : $this->subscriptionManager->subscribe($email, $storeId);

                if ($subscriber->getId()) {
                    $subscribernew = $this->_subscriberFactory->create()->loadBySubscriberEmail($email, $websiteId);
                    $subscribernew->setSubscriberFirstname($firstname)
                    ->setSubscriberLastname($lastname)
                    ->setStoreId($websiteId)
                    ->save();
                }
                /*Begin ORO Updates*/
                $mainemail = $email;	
	            $orodetails = array ('firstname'  => $firstname,
				                     'lastname'  => $lastname,	
			                         'leadsources' => 'newsletter'); 
			    $comm_preferences = array();		
			    $inc = 0;
			    $comm_preferences_id = 'contactcommunicationprefer71f420a4s';
		        if(!empty($this->getRequest()->getPost('comm_preferences'))){
                    foreach($this->getRequest()->getPost('comm_preferences') as $comm) {
                        if($comm == 'Email') { 
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'email';				
                            $inc++;
                        }
                        if($comm == 'Phone') { 
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'phone';
                            $inc++;
                        }
                        if($comm == 'IM') { 
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'im';
                            $inc++;
                        }
                        if($comm == 'Post') { 
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'post';
                            $inc++;
                        }
                    }
		        }
                if(!empty($this->getRequest()->getPost('hear_us'))){
                    $comm_preferences[$inc]['type'] = $comm_preferences_id;
                    $comm_preferences[$inc]['id'] = 'approved_partners';
                    $inc++;	
                }
            
                if(!empty($comm_preferences)) { $orodetails ['comm_preferences'] = $comm_preferences;}
                if(!empty($this->getRequest()->getPost('telephone'))) { 
                  $orodetails ['telephone'] = $this->getRequest()->getPost('telephone'); 
                } 
                //echo "<pre>";print_r($orodetails);exit;
                $this->oroConnectContacts($orodetails, $mainemail);
                /*EOF ORO Updates */
                $message = $this->getSuccessMessage((int)$subscriber->getSubscriberStatus());
                $this->messageManager->addSuccessMessage($message);
            } catch (LocalizedException $e) {
                $this->messageManager->addComplexErrorMessage(
                    'localizedSubscriptionErrorMessage',
                    ['message' => $e->getMessage()]
                );
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong with the subscription.'));
            }
        }
        /** @var Redirect $redirect */
        $redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $redirectUrl = $this->_redirect->getRedirectUrl();
        return $redirect->setUrl($redirectUrl);
    }

    /**
     * Get customer id from session if he is owner of the email
     *
     * @param string $email
     * @return int|null
     */
    private function getSessionCustomerId(string $email): ?int
    {
        if (!$this->_customerSession->isLoggedIn()) {
            return null;
        }

        $customer = $this->_customerSession->getCustomerDataObject();
        if ($customer->getEmail() !== $email) {
            return null;
        }

        return (int)$this->_customerSession->getId();
    }

    /**
     * Get success message
     *
     * @param int $status
     * @return Phrase
     */
    private function getSuccessMessage(int $status): Phrase
    {
        if ($status === Subscriber::STATUS_NOT_ACTIVE) {
            return __('The confirmation request has been sent.');
        }

        return __('Thank you for your subscription.');
    }

    private function oroConnectContacts($address, $customeremail)
    {
        $username = $this->_username;
        $apiUserKey = $this->_apiuserkey;
        $url = $this->_orourl;
   
        if(!preg_match('/[0-9]/', $address['firstname']))
        {   
            if(!empty($customeremail))
            {       
                $guestAcc = "2807";		
                $apicall = "magentocustomers?filter[email]=".$customeremail."&page[number]=1&page[size]=1&sort=id";			
                $getdata = $this->oroGetRequset($url, $apicall, $username, $apiUserKey, 'magentocustomers');
                        
                if(empty($getdata))
                {
                    $apicall = "contacts?filter[emails]=".$customeremail."&page[number]=1&page[size]=1&sort=id";
                    $getdata = $this->oroGetRequset($url, $apicall, $username, $apiUserKey, 'contact');
                    if(empty($getdata))
                    {
                            $apicall = "contacts";
                            $firstName = $address['firstname']; 
                            $contactsValues = array ( 'firstName' => $firstName,
                                'primaryEmail' => $customeremail
                            ); 
                            if(!empty($address['lastname'])) { $contactsValues ['lastName'] = $address['lastname'];}               
                            if(!empty($address['telephone'])) { $contactsValues ['primaryPhone'] = $address['telephone'];} 
                                    $relationships = array (
                                    'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
                                    'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
                                    'source' => array ('data' => array ("type" =>"contactsources", "id" => "website"))
                            );
                            if(!empty($address['comm_preferences'])) { 
                                $relationships ['CommunicationPrefer'] = array ('data' => $address['comm_preferences']);
                            }
                            // php array with data to update main entity
                            $contacts =   array ( 'data' => array ('type' => 'contacts' ,
                            'attributes' => $contactsValues,
                            'relationships' => $relationships
                            ));				
                            $getconentity = $this->oroCurlRequset($contacts, $url, $apicall, $username, $apiUserKey);
                            $getdata["contact"] = $getconentity;
                            $getdata["account"] = $guestAcc;
                    }
                    else {
                        $getdata["account"] = $guestAcc;
                    }	
                }
                
                if(empty($getdata))
                {
                $getdata["account"] = $guestAcc; 
                }
                if(!empty($getdata))
                {
                    $apicall = "leads";
                    //Set Contact datas
                    $name = $address['firstname'];
                    if(!empty($address['lastname'])) { $name .= " ".$address['lastname'];}
                    $firstName = $address['firstname']; 
                    $leadValues = array ( 'firstName' => $firstName, 
                            'name' => $name,
                            'primaryEmail' => $customeremail
                        ); 
                    if(!empty($address['lastname'])) { $leadValues ['lastName'] = $address['lastname'];}               
                    if(!empty($address['telephone'])) { $leadValues ['primaryPhone'] = $address['telephone'];}
                    if(!empty($address['companyName'])) { $leadValues ['companyName'] = $address['companyName'];}
                    if(!empty($address['courseSubject'])) { $leadValues ['courseSubject'] = $address['courseSubject'];}
                    if(!empty($address['noOfDelegates'])) { $leadValues ['noOfDelegates'] = $address['noOfDelegates'];}
                    if(!empty($address['courseLocation'])) { $leadValues ['courseLocation'] = $address['courseLocation'];}
                    if(!empty($address['certificateLevel'])) { $leadValues ['certificateLevel'] = $address['certificateLevel'];}
                    if(!empty($address['specifiedTimeFrame'])) { $leadValues ['specifiedTimeFrame'] = $address['specifiedTimeFrame'];}
                    if(!empty($address['courseSpecifiedBudget'])) { $leadValues ['courseSpecifiedBudget'] = $address['courseSpecifiedBudget'];}
                    if(!empty($address['hearAboutUs'])) { $leadValues ['hearAboutUs'] = $address['hearAboutUs'];}
                    if(!empty($address['notes'])) { $leadValues ['notes'] = $address['notes'];}
                    if(!empty($address['predownloadReferer'])) { $leadValues ['predownloadReferer'] = $address['predownloadReferer'];}
                    $relationships = array (
                                'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
                                'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
                                'status' => array ('data' => array ("type" =>"leadstatuses", "id" => "new")),
                                'source' => array ('data' => array ("type" =>"leadsources", "id" => $address['leadsources']))
                    );
                    if(!empty($getdata["account"])) {
                    $relationships ['account'] = array ('data' => array ("type" =>"accounts", "id" => $getdata["account"]));		
                    }
                    if(!empty($getdata["customer"])) {
                    $relationships ['customer'] = array ('data' => array ("type" =>"magentocustomers", "id" => $getdata["customer"]));
                    }
                    if(!empty($getdata["contact"])) {
                    $relationships ['contact'] = array ('data' => array ("type" =>"contacts", "id" => $getdata["contact"]));                  
                    }		
                    // php array with data to add on Leads
                    $contacts =   array ( 'data' => array ('type' => 'leads' ,
                            'attributes' => $leadValues,
                            'relationships' => $relationships
                    ));
                //echo "<pre>";print_r($contacts);exit;
                    $getentity = $this->oroCurlRequset($contacts, $url, $apicall, $username, $apiUserKey);
                    if(!empty($address['comm_preferences'])) {
                        $this->oroUpdateCommPref($getdata["contact"],$address);		
                    }		
                }
            }        
        }
    }

    private function oroUpdateCommPref($contactId,$address)
    {        
        $username = $this->_username;
        $apiUserKey = $this->_apiuserkey;
        $url = $this->_orourl;    
        if(!empty($contactId))
        {

            $apicall = "contacts/".$contactId."/relationships/CommunicationPrefer";
            $relationships = array ('data' => $address['comm_preferences']);
            $updatecontacts = $relationships;			
            $this->oroCurlUpdateRequset($updatecontacts, $url, $apicall, $username, $apiUserKey);	
        }	
    }

    private function oroCurlRequset($contactsdata, $url, $apicall, $username, $apiUserKey)
    {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url.$apicall);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
	$output = curl_exec($ch);
	$output = json_decode($output);	
        //print_r($output);exit;
	curl_close($ch);
	if(!empty($output->data->id))
	{
		return $output->data->id;
	}else{
		return;
	}
     }

    private function oroGetRequset($url, $apicall, $username, $apiUserKey, $module)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET'); //LET OP!! PATCH voor updates!!
        //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);
            // print_r($output);exit;
        curl_close($ch);
            $outArr = array();
            if( $module == 'magentocustomers') {        
            if(isset($output->data[0]->id) && !empty($output->data[0]->id)) {
                $outArr["customer"] = $output->data[0]->id;
                if(isset($output->data[0]->relationships->account->data->id) && !empty($output->data[0]->relationships->account->data->id))
                {	
                $outArr["account"] = $output->data[0]->relationships->account->data->id;		
                }
                if(isset($output->data[0]->relationships->contact->data->id) && !empty($output->data[0]->relationships->contact->data->id))
                {	
                $outArr["contact"] = $output->data[0]->relationships->contact->data->id;		
                }
            }
        }else{
            if(isset($output->data[0]->id) && !empty($output->data[0]->id)) {
                $outArr["contact"] = $output->data[0]->id;		
            }
        }
        return $outArr;
   }

   private function oroCurlUpdateRequset($contactsdata, $url, $apicall, $username, $apiUserKey)
   {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH'); //LET OP!! PATCH voor updates!!
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);	

        curl_close($ch);
        if(!empty($output->data->id))
        {
            return $output->data->id;
        }else{
            return;
        }
    }

   private function oroWsseheader($userName, $userPassword)
    {
        $nonce = uniqid();
        $created  = date('c');
        $digest   = base64_encode(sha1(base64_decode($nonce) . $created . $userPassword, true));
        $wsseHeader = array();
        //$wsseHeader[] = "Accept: application/json";
        $wsseHeader[] = "Content-Type: application/vnd.api+json";
        $wsseHeader[] = "Authorization: WSSE profile=\"UsernameToken\"";
        $code = sprintf(
                'X-WSSE: UsernameToken Username="%s", PasswordDigest="%s", Nonce="%s", Created="%s"',
                $userName,
                $digest,
                $nonce,
                $created
        );
        $wsseHeader[] = $code;
        return $wsseHeader;
    }
}
