<?php

namespace Expedux\Predownloads\Block\Adminhtml\Category\Edit\Tab;

use Magento\Backend\Block\Widget\Grid\Extended as ExtendedGrid;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory;
use Expedux\Predownloads\Model\ResourceModel\CategoryResources\CollectionFactory  as CategoryResourcescollection;
use Magento\Catalog\Model\Product\Type as ProductType;
use Magento\Catalog\Model\Product\Attribute\Source\Status as ProductStatus;
use Magento\Catalog\Model\Product\Visibility as ProductVisibility;
use Magento\Framework\Registry;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data as DataHelper;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory as SetCollectionFactory;
use Expedux\Predownloads\Model\ResourceFactory;
use Expedux\Predownloads\Model\CategoryResourcesFactory;
use Magento\Directory\Model\Currency;
use Magento\Store\Model\ScopeInterface;

/**
 * @method Product setUseAjax(\bool $useAjax)
 * @method array|null getCompanyProducts()
 * @method Product setCompanyProducts(array $products)
 */
class Resource extends ExtendedGrid implements TabInterface
{
    /**
     * @var \Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory
     */
    protected $resourceCollectionFactory;

    /**
     * @var \Magento\Catalog\Model\Product\Type
     */
    protected $type;

    /**
     * @var \Magento\Catalog\Model\Product\Attribute\Source\Status
     */
    protected $status;

    /**
     * @var \Magento\Catalog\Model\Product\Visibility
     */
    protected $visibility;

    /**
     * @var  \Magento\Framework\Registry
     */
    protected $registry;

    /**
     *
     * @var SetCollectionFactory
     */
    protected $setCollectionFactory;

    /**
     *
     * @var ResourceFactory
     */
    protected $resourceFactory;

    /**
     *
     * @param CollectionFactory $resourceCollectionFactory
     * @param ProductType $type
     * @param ProductStatus $status
     * @param ProductVisibility $visibility
     * @param Registry $registry
     * @param SetCollectionFactory $setsFactory
     * @param ResourceFactory $resourceFactory
     * @param Context $context
     * @param DataHelper $backendHelper
     * @param array $data
     */
    public function __construct(
        CollectionFactory $resourceCollectionFactory,
        ProductType $type,
        ProductStatus $status,
        ProductVisibility $visibility,
        Registry $registry,
        SetCollectionFactory $setsFactory,
        CategoryResourcescollection $categoryresourcesCollection,
        ResourceFactory $resourceFactory,
        Context $context,
        DataHelper $backendHelper,
        array $data = []
    ) {
        $this->resourceCollectionFactory = $resourceCollectionFactory;
        $this->type = $type;
        $this->status = $status;
        $this->visibility = $visibility;
        $this->registry = $registry;
        $this->setCollectionFactory = $setsFactory;
        $this->resourceFactory = $resourceFactory;
        $this->categoryresourcesCollection = $categoryresourcesCollection;
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * Set grid params
     */
    public function _construct()
    {
        parent::_construct();
        $this->setId('resource_grid');
        $this->setDefaultSort('position');
        $this->setDefaultDir('ASC');
        $this->setUseAjax(true);
       
    }

    /**
     * @return bool
     */
    public function isAjax()
    {
        return $this->_request->isXmlHttpRequest() || $this->_request->getParam('isAjax');
    }

    /**
     * Prepare the collection
     *
     * @return $this
     */
    protected function _prepareCollection()
    {
		$collection = $this->resourceCollectionFactory->create();
               
        $this->setCollection($collection);
        parent::_prepareCollection();

        return $this;
    }

    /**
     * @return $this
     */
    protected function _prepareMassaction()
    {
        return $this;
    }

    /**
     * @return $this
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'in_resources',
            [
                'header_css_class'  => 'a-center',
                'type'              => 'checkbox',
                'name'              => 'in_resources',
                'align'             => 'center',
                'values'            => $this->_getSelectedProducts(),
                'index'             => 'resource_id',
            ]
        );
        $this->addColumn(
            'resource_id',
            [
                'header'           => __('ID'),
                'sortable'         => true,
                'index'            => 'resource_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );
        $this->addColumn(
            'download_file',
            [
                'header'           => __('File'),
                'index'            => 'download_file',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );
        $this->addColumn(
            'resource_title',
            [
                'header'           => __('Title'),
                'index'            => 'resource_title',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        $this->addColumn(
            'resource_type',
            [
                'header'           => __('Type'),
                'index'            => 'resource_type',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        return $this;
    }

    /**
     * Retrieve selected products
     *
     * @return array
     */
    protected function _getSelectedProducts()
    {
        $array = array();
        $id = $this->_request->getParam('id');
        $selected = $this->categoryresourcesCollection->create()
                    ->addFieldToFilter('category_id', $id)
                    ->addFieldToSelect('resource_id');
       foreach($selected->getData() as $data){
        $array [] = $data['resource_id'];
       }
        return $array;
    }

    /**
     * Retrieve selected products
     *
     * @return array
     */
    public function getSelectedProducts()
    {
        $selected = $this->_getSelectedProducts();
        if (!is_array($selected)) {
            $selected = [];
        }
        return $selected;
    }
    /**
     * @param \Magento\Catalog\Model\Product|\Magento\Framework\Object $item
     * @return string
     */
    public function getRowUrl($item)
    {
        return '#';
    }
    /**
     * Get grid url
     *
     * @return string
     */
    public function getGridUrl()
    {
        $id = $this->_request->getParam('id');
        return $this->getUrl(
            '*/*/resourceGrid',
            [
                'id' => $id
            ]
        );
    }

    // /**
    //  * @param \Magento\Backend\Block\Widget\Grid\Column $column
    //  * @return $this
    //  */
    protected function _addColumnFilterToCollection($column)
    {
        if ($column->getId() == 'in_resources') {
            $productIds = $this->_getSelectedProducts();
            if (empty($productIds)) {
                $productIds = 0;
            }
            if ($column->getFilter()->getValue()) {
                $this->getCollection()->addFieldToFilter('resource_id', ['in'=>$productIds]);
            } else {
                if ($productIds) {
                    $this->getCollection()->addFieldToFilter('resource_id', ['nin'=>$productIds]);
                }
            }
        } else {
            parent::_addColumnFilterToCollection($column);
        }
        return $this;
    }

    /**
     * @return string
     */
    public function getTabLabel()
    {
        return __('Resources');
    }

    /**
     * @return bool
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * @return string
     */
    public function getTabTitle()
    {
        return $this->getTabLabel();
    }

    /**
     * @return bool
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getTabUrl()
    {
        return $this->getUrl('*/*/resource', ['_current' => true]);
    }

    /**
     * @return string
     */
    public function getTabClass()
    {
        return 'ajax only';
    }
	protected function getCategory()
    {
        return $this->registry->registry('expedux_predownloads_category');
    }

    
}