<?php

namespace Expedux\Predownloads\Block\Adminhtml\Resource\Edit;

class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Expedux\Predownloads\Model\Status $options,
        \Expedux\Predownloads\Model\Type $types,
        \Expedux\Predownloads\Model\Category $categoryoptions,
        \Magento\Customer\Model\ResourceModel\Group\Collection $customerGroup,
        array $data = []
    ) {
        $this->_options = $options;
        $this->_types = $types;
        $this->_categoryoptions = $categoryoptions;
        $this->_customerGroup = $customerGroup; 
        parent::__construct($context, $registry, $formFactory, $data);
    }


    protected function _prepareForm()
    {
        $attachment = $this->getAttachment();
        
        $model = $this->_coreRegistry->registry('row_data');
        $form = $this->_formFactory->create(
            ['data' => [
                            'id' => 'edit_form',
                            'enctype' => 'multipart/form-data',
                            'action' => $this->getData('action'),
                            'method' => 'post'
                        ]
            ]
        );
        #$form->setHtmlIdPrefix('zipcode_');
        if ($model->getId()) {
        
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Edit Resource'), 'class' => 'fieldset-wide']
            );
            $fieldset->addField('resource_id', 'hidden', ['name' => 'resource_id']);
            
        } else {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Add Resource'), 'class' => 'fieldset-wide']
            );
        }
       

        $fieldset->addField(
            'resource_title',
            'text',
            [
                'name' => 'resource_title',
                'label' => __('Title'),
                'id' => 'resource_title',
                'title' => __('resource_title'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'resource_type',
            'select',
            [
                'name' => 'resource_type',
                'label' => __('Type'),
                'id' => 'resource_type',
                'title' => __('resource_type'),
                'class' => 'required-entry',
                'value'  => '1',
                'values' => $this->_types->getOptionArray(),
                'required' => true,
            ]
        );
        $fieldset->addType('file', 'Expedux\Predownloads\Block\Adminhtml\Helper\File');
        $fieldset->addField(
            'download_file',
            'file',
            [
                'name' => 'download_file',
                'label' => __('Download File'),
                'id' => 'download_file',
                'index' => 'download_file',
                'title' => __('download_file'),
                'class' => '',
                'required' => false,
            ]
        );
        $fieldset->addField(
            'content',
            'textarea',
            [
                'name' => 'content',
                'label' => __('Content'),
                'id' => 'content',
                'title' => __('content'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'sort_order',
            'text',
            [
                'name' => 'sort_order',
                'label' => __('Sort Order'),
                'id' => 'sort_order',
                'title' => __('sort_order'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        
        $fieldset->addField(
            'status',
            'select',
            [
                'name' => 'status',
                'label' => __('Status'),
                'id' => 'status',
                'title' => __('Status'),
                'values' => $this->_options->getOptionArray(),
                'class' => 'status',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'is_hidden',
            'select',
            [
                'name' => 'is_hidden',
                'label' => __('Is Hidden'),
                'id' => 'is_hidden',
                'title' => __('is_hidden'),
                'class' => 'required-entry',
                'value'  => '1',
                'values' => array('1' => 'Yes','2' => 'No'),
                'required' => true,
            ]
        );
        
        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
    /**
     * Get customer groups
     * 
     * @return array
     */ 
    public function getCustomerGroups() {
        $customerGroups = $this->_customerGroup->toOptionArray();
        array_unshift($customerGroups, array('value'=>'', 'label'=>'Any'));
        return $customerGroups;
    }
    /**
     * Get maximum upload size message
     *
     * @return \Magento\Framework\Phrase
     */
    public function getMaxUploadSizeMessage()
    {
        $maxFileSize = $this->fileSize->getMaxFileSizeInMb();
        if ($maxFileSize) {
            $message = __('The maximum file size limit is %1M.', $maxFileSize);
        } else {
            $message = __('We can\'t provide the upload settings right now.');
        }
        return $message;
    }
}
