<?php
namespace Expedux\Predownloads\Block;
use Expedux\Predownloads\Model\ResourceModel\CategoryResources\CollectionFactory  as CategoryResourcescollection;
use Expedux\Predownloads\Model\ResourceModel\Category\CollectionFactory  as Categorycollection;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory  as Resourcecollection;
use Magento\Framework\App\Filesystem\DirectoryList;

class Category extends \Magento\Framework\View\Element\Template
{
    protected $storeManager;
	public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        CategoryResourcescollection $catresourceCollectionFactory,
        Categorycollection $categoryCollectionFactory,
        Resourcecollection $resourceCollectionFactory,
        \Magento\Catalog\Model\Session $catalogSession,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\Filesystem $filesystem
    )
    {      
        $this->storeManager = $storeManager;
        $this->catresourceCollectionFactory = $catresourceCollectionFactory;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->resourceCollectionFactory = $resourceCollectionFactory;
        $this->_catalogSession = $catalogSession;
        $this->_customerSession = $customerSession;
        $this->_filesystem = $filesystem;
        parent::__construct($context);
    }
    public function getCatalogSession() 
    {
        return $this->_catalogSession;
    }
    public function getCustomerSession() 
    {
        return $this->_customerSession;
    }
	public function getMyDocuments()
    {
        return 'You have no documents';
    }
    
    public function getDocumentPath(){
        return $this->storeManager
                     ->getStore()
                     ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
    }
     public function getFormAction()
    {
        return $this->getUrl('predownloads/index/submit', ['_secure' => true]);
    }
    public function setSessionData()
    {

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$session = $objectManager->create('Magento\Framework\Session\SessionManagerInterface');
		
		return $session->setError('curlerror');
    }

    public function getSessionData()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$session = $objectManager->create('Magento\Framework\Session\SessionManagerInterface');
		
        if($session->getError()){
			return $session->getError();
        }
        
        return false;
    }
    public function getCategoryResources()
    {
        $array = array();
        
        $collection = $this->catresourceCollectionFactory->create();
        
        foreach($collection->getData() as $data){
            $categorycollection = $this->categoryCollectionFactory->create()
            ->addFieldToFilter('category_id', $data['category_id']);
            $category_data = $categorycollection->getData()[0];
            $data['category_name'] = $category_data['category_name'];
           
            $resourcecollection = $this->resourceCollectionFactory->create()
            ->addFieldToFilter('resource_id', $data['resource_id']);
            
            if(!empty($resourcecollection->getData())){
                $resource_data = $resourcecollection->getData()[0];
                $data['resource_title'] = $resource_data['resource_title'];
            
            $mediapath = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath();

            $resource_data['download_file_path'] = $mediapath.'resources/'.$resource_data['download_file'];
            $resource_data['download_file'] = $this->getDocumentPath().'resources/'.$resource_data['download_file'];
           
            $array[$data['category_name']][]=$resource_data;
            }
           }
            return $array;
    }
}
