<?php
namespace Expedux\Predownloads\Block;
use Expedux\Predownloads\Model\ResourceModel\CategoryResources\CollectionFactory  as CategoryResourcescollection;
use Expedux\Predownloads\Model\ResourceModel\Category\CollectionFactory  as Categorycollection;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory  as Resourcecollection;
use Magento\Framework\App\Filesystem\DirectoryList;

class View extends \Magento\Framework\View\Element\Template
{
    protected $storeManager;
	public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        CategoryResourcescollection $catresourceCollectionFactory,
        Categorycollection $categoryCollectionFactory,
        Resourcecollection $resourceCollectionFactory,
        \Magento\Catalog\Model\Session $catalogSession,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\App\Request\Http $request
    )
    {      
        $this->storeManager = $storeManager;
        $this->catresourceCollectionFactory = $catresourceCollectionFactory;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->resourceCollectionFactory = $resourceCollectionFactory;
        $this->_catalogSession = $catalogSession;
        $this->_customerSession = $customerSession;
        $this->request = $request;
        parent::__construct($context);
    }
    public function getCatalogSession() 
    {
        return $this->_catalogSession;
    }
    public function getCustomerSession() 
    {
        return $this->_customerSession;
    }
	
    public function getDocumentPath(){
        return $this->storeManager
                     ->getStore()
                     ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
    }
    public function getResCategories()
    {
        $categoryAry = array();
        $categorycollection = $this->categoryCollectionFactory->create()
            ->addFieldToFilter('status', 1);
        foreach($categorycollection as $category){
            $categoryAry[$category->getData('category_id')] = $category->getData('category_name');
        }   
        return $categoryAry;
    }    


    public function getCategoryResources($id)
    {
        $array = array();
        
        $collection = $this->catresourceCollectionFactory->create()
        ->addFieldToFilter('category_id', $id);
        foreach($collection->getData() as $data){ 
            $resourcecollection = $this->resourceCollectionFactory->create()
            ->addFieldToFilter('resource_id', $data['resource_id'])
            ->addFieldToFilter('status', 1)
            ->setOrder('sort_order');

            if(!empty($resourcecollection->getData())){
                $resource_data = $resourcecollection->getData()[0];
                $data['resource_title'] = $resource_data['resource_title'];
            
            $mediapath = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath();

            $resource_data['download_file_path'] = $mediapath.$resource_data['download_file'];
            $resource_data['download_file'] = $this->getDocumentPath().$resource_data['download_file'];
           
            $array[] = $resource_data;
            }
           }
           
            return $array;
    }
    public function getResourceId()
    {
        return $this->getRequest()->getParam('id');
    } 
    public function getResourceById($id)
    {
        $resource_data = array();
        $resourcecollection = $this->resourceCollectionFactory->create()
            ->addFieldToFilter('resource_id', $id)
            ->addFieldToFilter('status', 1);
        if(!empty($resourcecollection->getData())){
            $resource_data = $resourcecollection->getData()[0];
            $mediapath = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath();
            $resource_data['download_file_path'] = $mediapath.$resource_data['download_file'];
            $resource_data['download_file'] = $this->getDocumentPath().$resource_data['download_file'];
        }
        return $resource_data;          
    }   
}
