<?php

namespace Expedux\Predownloads\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\RedirectFactory;
use \Expedux\Predownloads\Model\CategoryFactory;
use Magento\Framework\Registry;

abstract class Category extends \Magento\Backend\App\Action
{
    /**
     * Company factory
     *
     * @var categoryFactory
     */
    protected $categoryFactory;

    /**
     * Core registry
     *
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var RedirectFactory
     */
    protected $resultRedirectFactory;

    /**
     *
     * @param Registry $registry
     * @param categoryFactory $categoryFactory
     * @param Context $context
     */
    public function __construct(
        Registry $registry,
        CategoryFactory $categoryFactory,
        Context $context
    ) {

        $this->coreRegistry = $registry;
        $this->categoryFactory = $categoryFactory;
        $this->resultRedirectFactory = $context->getResultRedirectFactory();
        parent::__construct($context);
    }

    protected function initCategory()
    {
        $companyId = $this->getRequest()->getParam('id');
        $company   = $this->categoryFactory->create();
        if ($companyId) {
            $company->getResource()->load($company, $companyId);
        }
        $this->coreRegistry->register('expedux_predownloads_category', $company);
        return $company;
    }

    
    /**
     *
     * @param array $data
     * @return array
     */
    protected function filterData($data)
    {
        return $data;
    }
}
