<?php

namespace Expedux\Predownloads\Controller\Adminhtml\Category;

class Save extends \Magento\Backend\App\Action
{

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\Predownloads\Model\CategoryFactory $categoryFactory,
        \Expedux\Predownloads\Model\CategoryResourcesFactory $categoryresourceFactory
    ) {
        parent::__construct($context);
        $this->categoryFactory = $categoryFactory;
        $this->categoryresourceFactory = $categoryresourceFactory;
    }


    public function execute()
    {  
        $data = $this->getRequest()->getPostValue();
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->categoryFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['category_id'])){
                            $values->addFieldToFilter('category_id',['neq'=> $data['category_id']]);
                        }
                    $values->addFieldToFilter('category_name',['eq'=> $data['category_name']]);

            if(!$values->getSize())
            {
                    $rowData->setData($data);
                    $rowData->save();
                    if(isset($data['resources']) && !empty($data['resources']) && $rowData->getCategoryId()){
                        $resources = $data['resources'];
                        $deleterow = $this->categoryresourceFactory->create()->getCollection()->addFieldToFilter('category_id',['eq'=> $rowData->getCategoryId()]);
                         $deleterow->walk('delete');
                        if(strpos($data['resources'], '&') !== false) {
                         $resources = explode('&',$data['resources']);
                         
                         //$deleterow->delete();
                         foreach($resources as $resource){
                            $this->save_resource_data($this->categoryresourceFactory,$resource,$rowData->getCategoryId());
                         }
                        }else{
                            $this->save_resource_data($this->categoryresourceFactory,$resources,$rowData->getCategoryId());
                        }
                       
                        
                    }
                    $this->messageManager->addSuccess(__('Category has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Category already is there.'));
                if($this->_request->getParam('category_id')){
                    $this->_redirect('*/*/addnew', ['category_id' => $this->_request->getParam('category_id')]);
                }else{
                    $this->_redirect('*/*/addnew');  
                }
            }
    
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }
    public function save_resource_data($categoryresourceFactory,$resource,$category_id){
                         $resourcerow = $categoryresourceFactory->create();
                         $values = $resourcerow->getCollection();
                        
                    $values->addFieldToFilter('category_id',['eq'=> $category_id]);
                    $values->addFieldToFilter('resource_id',['eq'=> $resource]);
                    if(!$values->getSize())
                    {
                                $resourcedata['resource_id'] = $resource;
                                $resourcedata['category_id'] = $category_id;
                                $resourcerow->setData($resourcedata);
                                $resourcerow->save();
                    }
    }

}
