<?php

namespace Expedux\Predownloads\Controller\Adminhtml\Resource;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\MediaStorage\Model\File\UploaderFactory;
use Magento\Framework\Filesystem;
class Save extends \Magento\Backend\App\Action
{
    protected $uploaderFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\Predownloads\Model\ResourceFactory $resourceFactory,
        Filesystem $fileSystem,
        UploaderFactory $uploaderFactory 
    ) {
        parent::__construct($context);
        $this->resourceFactory = $resourceFactory;
        $this->uploaderFactory = $uploaderFactory; 
        $this->fileSystem = $fileSystem;
    }


    public function execute()
    {  

        $data = $this->getRequest()->getPostValue();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $fileSystem = $objectManager->create('\Magento\Framework\Filesystem');
        $mediaPath  =   $fileSystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)->getAbsolutePath();
        $media  =  $mediaPath.'documents/' ;
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->resourceFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['resource_id'])){
                            $values->addFieldToFilter('resource_id',['neq'=> $data['resource_id']]);
                        }
                    $values->addFieldToFilter('resource_title',['eq'=> $data['resource_title']]);

            if(!$values->getSize())
            {
                
           
                    $result = $this->saveFile('download_file');
                    $data['download_file'] = $result;
                    $rowData->setData($data);
                    $rowData->save();
                    $this->messageManager->addSuccess(__('Resource has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Resource already is there.'));
                if($this->_request->getParam('resource_id')){
                    $this->_redirect('*/*/addnew', ['resource_id' => $this->_request->getParam('resource_id')]);
                }else{
                    $this->_redirect('*/*/addnew');  
                }
            }
          

            
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }
    public function saveFile($image)
    {

        $imageRequest = $this->getRequest()->getFiles($image);
        
        if ($imageRequest && $imageRequest['name'] != '') {
            try {
                    $destinationPath = $this->getDestinationPath();
                    $uploader = $this->uploaderFactory->create(['fileId' => 'download_file']);
                    $uploader->setAllowRenameFiles(true);
                    $uploader->setFilesDispersion(true);

                    $mediaDirectory = $this->_objectManager->get('Magento\Framework\Filesystem')->getDirectoryRead(DirectoryList::MEDIA);
                    $result = $uploader->save($mediaDirectory->getAbsolutePath('resources'));
                    $imagePath = $result['file'];
                    return $imagePath; 
                    } catch (\Exception $e) {
                    if ($e->getCode() == 0) {
                        $this->messageManager->addError($e->getMessage());
                    }
                }
            } else {
                $data = $this->getRequest()->getPostValue();
            if (isset($data[$image]) && isset($data[$image]['value'])) {
                if (isset($data[$image]['delete'])) {
                    return null;
                } elseif (isset($data[$image]['value'])) {
                    return $data[$image]['value'];
                } else {
                    return null;
                }
            }
        }
        
    }
    public function getDestinationPath()
    {
        return $this->fileSystem
            ->getDirectoryWrite(DirectoryList::MEDIA)
            ->getAbsolutePath('/');
    }

}
