<?php

namespace Expedux\Predownloads\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory  as Resourcecollection;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\App\Filesystem\DirectoryList;
class Showpdf extends Action
{
    protected $_pageFactory;
    protected $postFactory;

    public function __construct(
        Context $context,
        Resourcecollection $resourceCollectionFactory,
        CustomerSession $customerSession,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Filesystem $filesystem,
        PageFactory $_pageFactory
    ) {
        $this->_pageFactory = $_pageFactory;
        $this->storeManager = $storeManager;
        $this->resource = $resourceCollectionFactory;
        $this->_customerSession = $customerSession;
        $this->_filesystem = $filesystem;
        parent::__construct($context);
    }

    public function execute()
    {
        $id = $this->getRequest()->getPost('bid');
        $errmsg = "No data available";
        if (!empty($id)) {
            $resourcecollection = $this->resource->create()
            ->addFieldToFilter('resource_id', $id)
            ->addFieldToFilter('status', 1);
            if(!empty($resourcecollection->getData())){
                $pdfhtml = '';                
                $resource_data = $resourcecollection->getData()[0];
                $this->setPageRequest($id, $resource_data['resource_title']);
                $filesize = (round(filesize($this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath()."/".$resource_data['download_file'])* .0009765625)). 'KB';
                $filepath = $this->getDocumentPath().$resource_data['download_file'];
                $pdfhtml .= $resource_data['content'].'<br />';
                $pdfhtml .= 'Full Product, Size '.$filesize.'<br />';
                $pdfhtml .= '<a href="'.$filepath.'">Download Here</a><br /><br /><br />';
                $pdfhtml .= '<iframe frameborder="0" height="500px;" id="phpIframe" marginheight="0" marginwidth="0" name="phpIframe" src="'.$filepath.'" width="100%" ></iframe>';
                echo $pdfhtml;
                exit();
            }
            else{
                echo $errmsg;
                exit();
            }
        }
        else{
            echo $errmsg;
            exit();
        }

    }
    public function setPageRequest($id, $pageRequest)
	{
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
        $connection = $resource->getConnection();
        $tableName = $resource->getTableName('predownloads_referer');     
        $checkReferersql = "SELECT COUNT(*) FROM " . $tableName . " WHERE email='".$this->_customerSession->getPredownloadEmail()."' AND page_request='".$pageRequest."'
        AND DATE(created_at) = CURDATE()";
        $checkRefererExist = $connection->fetchOne($checkReferersql);
        if($checkRefererExist == 0 )
        {
            $pageReferer = '';
            $reffsql = "INSERT INTO " . $tableName . " (email, page_request, referer, created_at) VALUES "
            . "('" . $this->_customerSession->getPredownloadEmail() . "', '" .$pageRequest . "', '" . $pageReferer . "', NOW())";
             $connection->query($reffsql); 
             return true;   
        }  
        return false;	
    }
    public function getDocumentPath(){
        return $this->storeManager
                     ->getStore()
                     ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
    }
}
