<?php

namespace Expedux\Predownloads\Controller\Index;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory  as Resourcecollection;

class Submit extends Action
{
    protected $resultPageFactory;
    protected $_orourl = 'https://orocrm.spoce.com/api/';
    protected $_username = 'root';
    protected $_apiuserkey = '0a9b22da6266bd33d20056598e414e51a9afe0c2';
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Expedux\Predownloads\Model\PreDownloadsFactory $predownloadFactory,
        \Expedux\Predownloads\Model\ResourceFactory $resourceFactory,
        Resourcecollection $resourceCollectionFactory,
        \Magento\Customer\Model\Session $customerSession
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->predownloadFactory = $predownloadFactory;
        $this->resourceFactory = $resourceFactory;
        $this->resourceCollectionFactory = $resourceCollectionFactory;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $data = (array)$this->getRequest()->getPost();           
            $predownloadId = 0;
            if ($data) {                
                if($this->_customerSession->getPredownloadId())
                {
                    $predownloadId = $this->_customerSession->getPredownloadId();
                }
                $comm_preferences_arr = array();
			    if(!empty($this->getRequest()->getPost('comm_preferences'))) {
				foreach($this->getRequest()->getPost('comm_preferences') as $comm) {
					if($comm == 'Email') {
						$comm_preferences_arr[] = 'email';
					}
					if($comm == 'Phone') {
						$comm_preferences_arr[] = 'phone';
					}
					if($comm == 'IM') {
						$comm_preferences_arr[] = 'im';
					}
					if($comm == 'Post') {
						$comm_preferences_arr[] = 'post';
					}
				}
			}
			if(!empty($this->getRequest()->getPost('hear_us'))) {
				$comm_preferences_arr[] = 'approved_partners';
			}
			$comm_preferences_str = '';
			if(count($comm_preferences_arr) > 0)
			{
				$comm_preferences_str = implode(',', $comm_preferences_arr);
			}
            $predownloads = $this->predownloadFactory->create();
			$data['email'] = $data['post_content'];
			$data['telephone'] = $data['telephone'];
			$data['comm_preferences'] = $comm_preferences_str;
			$data['created_at'] = date('Y-m-d H:i:s');
            $data['status'] = 1;
            $predownloads->setData($data);                   
			if($predownloads->save())
        	{  
                    $this->_customerSession->setPredownload(1);
                    $this->_customerSession->setPredownloadEmail($data['email']);
                    $pageReferer = $this->_customerSession->getPredownloadReferer();
                    if(!empty($pageReferer))
                    { 
                        $page_request='';
                        if($predownloadId > 0)
                        {
                            $resourcecollection = $this->resourceCollectionFactory->create()
                            ->addFieldToFilter('resource_id', $predownloadId)
                            ->addFieldToFilter('status', 1);
                            if(!empty($resourcecollection->getData())){
                                $resource_data = $resourcecollection->getData()[0];
                                $page_request = $resource_data['resource_title']; 
                                //$preId = $resource_data['resource_id'];
                            }
                        }  
                        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                        $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
                        $connection = $resource->getConnection();
                        $tableName = $resource->getTableName('predownloads_referer');
                        $reffsql = "INSERT INTO " . $tableName . " (email, page_request, referer, created_at) VALUES "
                    . "('" . $data['email'] . "', '" . $page_request . "', '" . $pageReferer . "', NOW())";
                        $connection->query($reffsql); 
                        $this->_customerSession->unsPredownloadReferer();                     
                    }
                
                //begin oro lead 
                $mainemail = $data['email'];       
                $orodetails = array ('firstname'  => $data['name'],
				         'hearAboutUs'  => $data['referer'],
			             'leadsources' => 'download',
						 'predownloadReferer' => 1);
			$comm_preferences = array();
			$inc = 0;
			$comm_preferences_id = 'contactcommunicationprefer71f420a4s';
		        if(!empty($this->getRequest()->getPost('comm_preferences'))){
                    foreach($this->getRequest()->getPost('comm_preferences') as $comm) {
                        if($comm == 'Email') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'email';
                            $inc++;
                        }
                        if($comm == 'Phone') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'phone';
                            $inc++;
                        }
                        if($comm == 'IM') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'im';
                            $inc++;
                        }
                        if($comm == 'Post') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'post';
                            $inc++;
                        }
                    }
		        }
                    if(!empty($this->getRequest()->getPost('hear_us'))){
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'approved_partners';
                        $inc++;
                    }
                    if(!empty($comm_preferences)) { 
                        $orodetails ['comm_preferences'] = $comm_preferences;
                    }
                    if(!empty($this->getRequest()->getPost('tags'))) {
                    $orodetails ['telephone'] = $this->getRequest()->getPost('tags');
                    }
                    $this->oroConnectContacts($orodetails, $mainemail);
                    //EOF oro Lead
                    
                    $this->messageManager->addSuccessMessage(__("Data Saved Successfully. Thank you"));
                }else{
                    $this->messageManager->addErrorMessage(__('Unable to submit your request. Please, try again later'));
                }
               
            }else
            {
                $this->messageManager->addErrorMessage(__('Unable to submit your request. Please, try again later'));
            }            
            if($predownloadId > 0)
            {
                return $this->resultRedirectFactory->create()->setPath(
                    'predownloads/index/view',
                    [   
                        'id' => $predownloadId,                         
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
                
            }
            else
            {
                return $this->resultRedirectFactory->create()->setPath(
                    'predownloads/index/index',
                    [                                        
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );               
            }

        } catch (\Exception $e) {
            echo "<pre>";print_r($e);exit;
            $this->messageManager->addErrorMessage(__("We can\'t submit your request, Please try again."));
        }       
        return $this->resultRedirectFactory->create()->setPath(
            'predownloads/index/form',
            [                                        
                '_secure' => $this->getRequest()->isSecure(),
            ]
        ); 
    }

    private function oroConnectContacts($address, $customeremail)
    {
        $username = $this->_username;
        $apiUserKey = $this->_apiuserkey;
        $url = $this->_orourl;
   
        if(!preg_match('/[0-9]/', $address['firstname']))
        {   
            if(!empty($customeremail))
            {       
                $guestAcc = "2807";		
                $apicall = "magentocustomers?filter[email]=".$customeremail."&page[number]=1&page[size]=1&sort=id";			
                $getdata = $this->oroGetRequset($url, $apicall, $username, $apiUserKey, 'magentocustomers');
                        
                if(empty($getdata))
                {
                    $apicall = "contacts?filter[emails]=".$customeremail."&page[number]=1&page[size]=1&sort=id";
                    $getdata = $this->oroGetRequset($url, $apicall, $username, $apiUserKey, 'contact');
                    if(empty($getdata))
                    {
                            $apicall = "contacts";
                            $firstName = $address['firstname']; 
                            $contactsValues = array ( 'firstName' => $firstName,
                                'primaryEmail' => $customeremail
                            ); 
                            if(!empty($address['lastname'])) { $contactsValues ['lastName'] = $address['lastname'];}               
                            if(!empty($address['telephone'])) { $contactsValues ['primaryPhone'] = $address['telephone'];} 
                                    $relationships = array (
                                    'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
                                    'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
                                    'source' => array ('data' => array ("type" =>"contactsources", "id" => "website"))
                            );
                            if(!empty($address['comm_preferences'])) { 
                                $relationships ['CommunicationPrefer'] = array ('data' => $address['comm_preferences']);
                            }
                            // php array with data to update main entity
                            $contacts =   array ( 'data' => array ('type' => 'contacts' ,
                            'attributes' => $contactsValues,
                            'relationships' => $relationships
                            ));				
                            $getconentity = $this->oroCurlRequset($contacts, $url, $apicall, $username, $apiUserKey);
                            $getdata["contact"] = $getconentity;
                            $getdata["account"] = $guestAcc;
                    }
                    else {
                        $getdata["account"] = $guestAcc;
                    }	
                }
                
                if(empty($getdata))
                {
                $getdata["account"] = $guestAcc; 
                }
                if(!empty($getdata))
                {
                    $apicall = "leads";
                    //Set Contact datas
                    $name = $address['firstname'];
                    if(!empty($address['lastname'])) { $name .= " ".$address['lastname'];}
                    $firstName = $address['firstname']; 
                    $leadValues = array ( 'firstName' => $firstName, 
                            'name' => $name,
                            'primaryEmail' => $customeremail
                        ); 
                    if(!empty($address['lastname'])) { $leadValues ['lastName'] = $address['lastname'];}               
                    if(!empty($address['telephone'])) { $leadValues ['primaryPhone'] = $address['telephone'];}
                    if(!empty($address['companyName'])) { $leadValues ['companyName'] = $address['companyName'];}
                    if(!empty($address['courseSubject'])) { $leadValues ['courseSubject'] = $address['courseSubject'];}
                    if(!empty($address['noOfDelegates'])) { $leadValues ['noOfDelegates'] = $address['noOfDelegates'];}
                    if(!empty($address['courseLocation'])) { $leadValues ['courseLocation'] = $address['courseLocation'];}
                    if(!empty($address['certificateLevel'])) { $leadValues ['certificateLevel'] = $address['certificateLevel'];}
                    if(!empty($address['specifiedTimeFrame'])) { $leadValues ['specifiedTimeFrame'] = $address['specifiedTimeFrame'];}
                    if(!empty($address['courseSpecifiedBudget'])) { $leadValues ['courseSpecifiedBudget'] = $address['courseSpecifiedBudget'];}
                    if(!empty($address['hearAboutUs'])) { $leadValues ['hearAboutUs'] = $address['hearAboutUs'];}
                    if(!empty($address['notes'])) { $leadValues ['notes'] = $address['notes'];}
                    if(!empty($address['predownloadReferer'])) { $leadValues ['predownloadReferer'] = $address['predownloadReferer'];}
                    $relationships = array (
                                'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
                                'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
                                'status' => array ('data' => array ("type" =>"leadstatuses", "id" => "new")),
                                'source' => array ('data' => array ("type" =>"leadsources", "id" => $address['leadsources']))
                    );
                    if(!empty($getdata["account"])) {
                    $relationships ['account'] = array ('data' => array ("type" =>"accounts", "id" => $getdata["account"]));		
                    }
                    if(!empty($getdata["customer"])) {
                    $relationships ['customer'] = array ('data' => array ("type" =>"magentocustomers", "id" => $getdata["customer"]));
                    }
                    if(!empty($getdata["contact"])) {
                    $relationships ['contact'] = array ('data' => array ("type" =>"contacts", "id" => $getdata["contact"]));                  
                    }		
                    // php array with data to add on Leads
                    $contacts =   array ( 'data' => array ('type' => 'leads' ,
                            'attributes' => $leadValues,
                            'relationships' => $relationships
                    ));
                //echo "<pre>";print_r($contacts);exit;
                    $getentity = $this->oroCurlRequset($contacts, $url, $apicall, $username, $apiUserKey);
                    if(!empty($address['comm_preferences'])) {
                        $this->oroUpdateCommPref($getdata["contact"],$address);		
                    }		
                }
            }        
        }
    }

    private function oroUpdateCommPref($contactId,$address)
    {        
        $username = $this->_username;
        $apiUserKey = $this->_apiuserkey;
        $url = $this->_orourl;    
        if(!empty($contactId))
        {

            $apicall = "contacts/".$contactId."/relationships/CommunicationPrefer";
            $relationships = array ('data' => $address['comm_preferences']);
            $updatecontacts = $relationships;			
            $this->oroCurlUpdateRequset($updatecontacts, $url, $apicall, $username, $apiUserKey);	
        }	
    }

    private function oroCurlRequset($contactsdata, $url, $apicall, $username, $apiUserKey)
    {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url.$apicall);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
	curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
	$output = curl_exec($ch);
	$output = json_decode($output);	
        //print_r($output);exit;
	curl_close($ch);
	if(!empty($output->data->id))
	{
		return $output->data->id;
	}else{
		return;
	}
     }

    private function oroGetRequset($url, $apicall, $username, $apiUserKey, $module)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET'); //LET OP!! PATCH voor updates!!
        //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);
            // print_r($output);exit;
        curl_close($ch);
            $outArr = array();
            if( $module == 'magentocustomers') {        
            if(isset($output->data[0]->id) && !empty($output->data[0]->id)) {
                $outArr["customer"] = $output->data[0]->id;
                if(isset($output->data[0]->relationships->account->data->id) && !empty($output->data[0]->relationships->account->data->id))
                {	
                $outArr["account"] = $output->data[0]->relationships->account->data->id;		
                }
                if(isset($output->data[0]->relationships->contact->data->id) && !empty($output->data[0]->relationships->contact->data->id))
                {	
                $outArr["contact"] = $output->data[0]->relationships->contact->data->id;		
                }
            }
        }else{
            if(isset($output->data[0]->id) && !empty($output->data[0]->id)) {
                $outArr["contact"] = $output->data[0]->id;		
            }
        }
        return $outArr;
   }

   private function oroCurlUpdateRequset($contactsdata, $url, $apicall, $username, $apiUserKey)
   {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH'); //LET OP!! PATCH voor updates!!
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);	

        curl_close($ch);
        if(!empty($output->data->id))
        {
            return $output->data->id;
        }else{
            return;
        }
    }

   private function oroWsseheader($userName, $userPassword)
    {
        $nonce = uniqid();
        $created  = date('c');
        $digest   = base64_encode(sha1(base64_decode($nonce) . $created . $userPassword, true));
        $wsseHeader = array();
        //$wsseHeader[] = "Accept: application/json";
        $wsseHeader[] = "Content-Type: application/vnd.api+json";
        $wsseHeader[] = "Authorization: WSSE profile=\"UsernameToken\"";
        $code = sprintf(
                'X-WSSE: UsernameToken Username="%s", PasswordDigest="%s", Nonce="%s", Created="%s"',
                $userName,
                $digest,
                $nonce,
                $created
        );
        $wsseHeader[] = $code;
        return $wsseHeader;
    }
}