<?php
namespace Expedux\Predownloads\Model;
class Category extends \Magento\Framework\Model\AbstractModel implements \Magento\Framework\DataObject\IdentityInterface
{
	const CACHE_TAG = 'expedux_predownloads_category';

	protected $_cacheTag = 'expedux_predownloads_category';

	protected $_eventPrefix = 'expedux_predownloads_category';

	protected function _construct()
	{
		$this->_init('Expedux\Predownloads\Model\ResourceModel\Category');
	}

	public function getIdentities()
	{
		return [self::CACHE_TAG . '_' . $this->getId()];
	}

	public function getDefaultValues()
	{
		$values = [];

		return $values;
	}
	public function getAllOptions($withEmpty = true)
    {
     
		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();

		$productCollection = $objectManager->create('Expedux\Predownloads\Model\ResourceModel\Category\CollectionFactory');

		$collection = $productCollection->create()	
					->load();
		$options=array();
		foreach ($collection as $product){
			$options[$product->getCategoryId()]  = $product->getCategoryName() ; 
		}  

        return $options;
	}
	/**
     * @return array|mixed
     */
    public function getResources()
    {
        if (!$this->getId()) {
            return [];
        }
        $array = $this->getData('resources');
        if (is_null($array)) {
            $array = $this->getResource()->getResources($this);
            $this->setData('resources', $array);
        }
        return $array;
    }
	

}

