<?php
namespace Expedux\Predownloads\Setup;

use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class UpgradeData implements UpgradeDataInterface
{
    private $customerSetupFactory;

    public function __construct(\Magento\Customer\Setup\CustomerSetupFactory $customerSetupFactory)
    {
        $this->customerSetupFactory = $customerSetupFactory;
    }

    public function upgrade(ModuleDataSetupInterface
         $setup, ModuleContextInterface $context) {
        /** @var CustomerSetup $customerSetup */

        $setup->startSetup();
       
        if (version_compare($context->getVersion(), '1.0.4') < 0) {
            $columns = [];
            $columns = ['course_names_id', 'title','link','status','sort_order'];
            $data = [
                [1, 'PRINCE2®', '/courses/agile-project/prince2/prince2-training', 1, 1],
                [2, 'MSP®', '/courses/programme-portfolio/msp-managing-successful-programmes/msp-training', 1, 3],
                [3, 'M_o_R®', '/courses/risk-change/mor-management-of-risk/mor-course-dates', 1, 7],
                [4, 'ITIL®', '/courses/it-service-management/itil-it-service-management/itil-training', 1, 5],
                [5, 'APM', '/courses/agile-project/apm-association-for-project-management/apm-training', 1, 4],
                [6, 'CHANGE MANAGEMENT', '/courses/risk-change/change-management/change-management-training', 1, 9],
                [7, 'BETTER BUSINESS CASES', '/courses/programme-portfolio/better-business-case/bbc-training', 1, 10],
                [8, 'RESILIA', '/courses/it-service-management/cyber-resilience/resilia-cyber-resilience-elearning-online-courses', 1, 12],
                [9, 'AgilePM®', '/courses/agile-project/agilepm-project-management/agile-pm-training', 1, 2],
                [10, 'MoP®', '/courses/programme-portfolio/mop-management-of-portfolios/mop-course-dates', 1, 12],
                [11, 'BUSINESS ANALYSIS', '/courses/it-service-management/business-analysis/business-analysis-distance-and-online-learning', 1, 11],
                [12, 'LEAN IT', '/lean-it-foundation-2-day', 1, 15],
                [13, 'PRINCE2 AGILE®', '/courses/agile-project/prince2-agile/prince2-agile-training', 1, 6],
                [14, 'P3O®', '/courses/programme-portfolio/p3o-portfolio-programme-project-offices/p3o-training', 1, 13],
                [15, 'MoV®', '/courses/programme-portfolio/mov-management-of-value/mov-training', 1, 14],
                [16, 'MS PROJECT', '/courses/agile-project/microsoft-project', 1, 16],
                [17, 'MOD/CTP/ELC - Enhanced Learning Credits', '/elc-home', 1, 8]
            ];
            
            $setup->getConnection()
                    ->insertArray($setup->getTable('search_course_names'),$columns,  $data);
        }

        if (version_compare($context->getVersion(), '1.0.5') < 0) {
            $columns = [];
            $columns = ['course_types_id','course_names_id', 'title','link','status','sort_order'];
            $data = [
                [1, 1, 'Foundation Courses', '/courses/agile-project/prince2/prince2-course-dates?course_type=269', 1, 1],
                [2, 1, 'Foundation &amp; Practitioner', '/courses/agile-project/prince2/prince2-course-dates?course_type=267', 1, 2],
                [3, 1, 'Practitioner Upgrade', '/courses/agile-project/prince2/prince2-course-dates?course_type=268', 1, 3],
                [4, 1, 'eLearning Packages', '/courses/agile-project/prince2/prince2-distance-online-courses', 1, 4],
                [5, 5, 'PFQ', '/courses/agile-project/apm-association-for-project-management/apm-course-dates?course_type=520', 1, 1],
                [6, 5, 'PMQ', '/courses/agile-project/apm-association-for-project-management/apm-course-dates?ajaxcatalog=true&course_type=265', 1, 2],
                [7, 5, 'PMQ for P2 Practitioners', '/courses/agile-project/apm-association-for-project-management/apm-course-dates?course_type=264', 1, 3],
                [8, 5, 'E-Learning', '/courses/agile-project/apm-association-for-project-management/apm-fundamentals-elearning', 1, 4],
                [9, 2, 'Foundation', '/courses/programme-portfolio/msp-managing-successful-programmes/msp-course-dates?course_type=269', 1, 1],
                [10, 2, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/msp-managing-successful-programmes/msp-course-dates?course_type=267', 1, 2],
                [11, 2, 'Practitioner Upgrade', '/courses/programme-portfolio/msp-managing-successful-programmes/msp-course-dates?course_type=268', 1, 3],
                [12, 2, 'E-Learning', '/courses/programme-portfolio/msp-managing-successful-programmes/msp-distance-online-courses', 1, 4],
                [13, 3, 'Foundation', '/courses/programme-portfolio/mov-management-of-value?course_type=269', 1, 1],
                [14, 3, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/mov-management-of-value?course_type=267', 1, 2],
                [15, 3, 'Practitioner Upgrade', '/courses/programme-portfolio/mov-management-of-value?course_type=268', 1, 3],
                [16, 4, 'Foundation', '/courses/it-service-management/itil-it-service-management/itil-training?course_type=269', 1, 1],
                [17, 4, 'Foundation &amp; Practitioner', '/courses/it-service-management/itil-it-service-management/itil-trainingcourse_type=267', 1, 2],
                [18, 4, 'Practitioner Upgrade', '/courses/it-service-management/itil-it-service-management/itil-training?course_type=268', 1, 3],
                [19, 4, 'E-Learning', '/courses/it-service-management/itil-it-service-management/itil-distance-online-courses', 1, 4],
                [20, 6, 'Foundation', '/courses/risk-change/change-management/change-management-training?course_type=269', 1, 1],
                [21, 6, 'Foundation &amp; Practitioner', '/courses/risk-change/change-management/change-management-training?course_type=267', 1, 2],
                [22, 6, 'Practitioner Upgrade', '/courses/risk-change/change-management/change-management-training?course_type=268', 1, 3],
                [23, 11, 'E-Learning', '/courses/it-service-management/business-analysis/business-analysis-distance-and-online-learning', 1, 1],
                [24, 8, 'E-Learning', '/courses/it-service-management/cyber-resilience/resilia-cyber-resilience-elearning-online-courses', 1, 1],
                [25, 9, 'Foundation', '/courses/agile-project/agilepm-project-management/agile-pm-course-dates?course_type=269', 1, 1],
                [26, 9, 'Foundation &amp; Practitioner', '/courses/agile-project/agilepm-project-management/agile-pm-course-dates?course_type=267', 1, 2],
                [27, 9, 'Practitioner Upgrade', '/courses/agile-project/agilepm-project-management/agile-pm-course-dates?course_type=268', 1, 3],
                [28, 9, 'E-Learning', '/courses/agile-project/agilepm-project-management/agile-pm-distance-online-courses', 1, 4],
                [29, 10, 'Foundation', '/courses/programme-portfolio/mop-management-of-portfolios/mop-course-dates?course_type=269', 1, 1],
                [30, 10, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/mop-management-of-portfolios/mop-course-dates?course_type=267', 1, 2],
                [31, 10, 'Practitioner Upgrade', '/courses/programme-portfolio/mop-management-of-portfolios/mop-course-dates?course_type=268', 1, 3],
                [32, 7, 'Foundation', '/courses/programme-portfolio/better-business-case/bbc-course-dates?course_type=269', 1, 1],
                [33, 7, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/better-business-case/bbc-course-dates?course_type=267', 1, 2],
                [34, 7, 'Practitioner Upgrade', '/courses/programme-portfolio/better-business-case/bbc-course-dates?course_type=268', 1, 3],
                [35, 12, 'E-Learning', '/lean-it-foundation-2-day', 1, 1],
                [36, 14, 'Foundation', '/courses/programme-portfolio/p3o-portfolio-programme-project-offices/course-dates?course_type=269', 1, 1],
                [37, 13, 'Practitioner Upgrade', '/courses/agile-project/prince2-agile/prince2-agile-course-dates', 1, 1],
                [38, 13, 'E-Learning', '/courses/agile-project/prince2-agile/prince2-agile-online-and-distance-learning', 1, 2],
                [39, 14, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/p3o-portfolio-programme-project-offices/course-dates?course_type=267', 1, 2],
                [40, 14, 'Practitioner Upgrade', '/courses/programme-portfolio/p3o-portfolio-programme-project-offices/course-dates?course_type=268', 1, 3],
                [41, 15, 'Foundation', '/courses/programme-portfolio/mov-management-of-value?course_type=269', 1, 1],
                [42, 15, 'Foundation &amp; Practitioner', '/courses/programme-portfolio/mov-management-of-value?course_type=267', 1, 2],
                [43, 15, 'Practitioner Upgrade', '/courses/programme-portfolio/mov-management-of-value?course_type=268', 1, 3],
                [44, 16, 'Intro and intermediate', '/microsoft-project-intro-intermediate-course', 1, 1],
                [45, 1, 'Re-Registration Packages', '/courses/agile-project/prince2/prince2-re-reg', 1, 4],
                [46, 1, 'Exam Only Packages', '/courses/agile-project/prince2/prince2-exams-only', 1, 4],
                [47, 1, 'MOD/CTP/ELC - Enhanced Learning Credits', '/elc-home', 1, 4],
                [48, 17, 'PRINCE2®', '/elc-home', 1, 1],
                [49, 17, 'AgilePM®', '/elc-home', 1, 1],
                [50, 17, ' APM - PFQ / PMQ', '/elc-home', 1, 1],
                [51, 17, 'PRINCE2 Agile®', '/elc-home', 1, 1],
                [52, 17, 'MSP®', '/elc-home', 1, 1],
                [53, 17, 'Change Management', '/elc-home', 1, 1],
                [54, 17, 'COMBI Courses / Packages', '/elc-home', 1, 1]
            ];
            
            $setup->getConnection()
                    ->insertArray($setup->getTable('search_course_types'),$columns,  $data);
        }
    
        $setup->endSetup();
    }
}