<?php
namespace Expedux\Predownloads\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
	public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
		$installer = $setup;

		$installer->startSetup();

		if(version_compare($context->getVersion(), '1.0.2', '<')) {
			if (!$installer->tableExists('expedux_predownloads_category')) {
				$table = $installer->getConnection()->newTable(
					$installer->getTable('expedux_predownloads_category')
				)
					->addColumn(
						'category_id',
						\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						null,
						[
							'identity' => true,
							'nullable' => false,
							'primary'  => true,
							'unsigned' => true,
						],
						'Category ID'
					)
					->addColumn(
						'category_name',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Category Name'
					)
					->addColumn(
						'status',
						\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						1,
						[],
						'Category Status'
					)
					->addColumn(
						'created_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
						'Created At'
					)->addColumn(
						'updated_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
						'Updated At')
					->setComment('Category Table');
				$installer->getConnection()->createTable($table);

				$installer->getConnection()->addIndex(
					$installer->getTable('expedux_predownloads_category'),
					$setup->getIdxName(
						$installer->getTable('expedux_predownloads_category'),
						['category_name'],
						\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
					),
					['category_name'],
					\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
				);
			}
		}

        if(version_compare($context->getVersion(), '1.0.2', '<')) {
			if (!$installer->tableExists('expedux_predownloads_resources')) {
				$table = $installer->getConnection()->newTable(
					$installer->getTable('expedux_predownloads_resources')
				)
					->addColumn(
						'resource_id',
						\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						null,
						[
							'identity' => true,
							'nullable' => false,
							'primary'  => true,
							'unsigned' => true,
						],
						'Resource ID'
					)
					->addColumn(
						'resource_title',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Resource Title'
					)
					->addColumn(
						'resource_type',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Resource Type'
					)
					->addColumn(
						'download_file',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Download File'
					)
					->addColumn(
						'content',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Content'
					)
					->addColumn(
						'sort_order',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Sort Order'
					)
					->addColumn(
						'status',
						\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						1,
						['nullable => false'],
						'Status'
					)
					->addColumn(
						'is_hidden',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable => false'],
						'Is Hidden'
					)
					
					->addColumn(
						'created_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
						'Created At'
					)->addColumn(
						'updated_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
						'Updated At')
					->setComment('Resource Table');
				$installer->getConnection()->createTable($table);

				$installer->getConnection()->addIndex(
					$installer->getTable('expedux_predownloads_resources'),
					$setup->getIdxName(
						$installer->getTable('expedux_predownloads_resources'),
						['resource_title'],
						\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
					),
					['resource_title'],
					\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
				);
			}
		}
		if(version_compare($context->getVersion(), '1.0.3', '<')) {
		 //Product Relation
		 $tableNameResource = $installer->getTable('expedux_predownloads_resource_relation');
		 // Create tutorial_simplenews table
		 $tableResource = $installer->getConnection()
		 ->newTable($tableNameResource)
		 ->addColumn(
		 'id',
		 \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
		 null,
		 [
		 'identity' => true,
		 'unsigned' => true,
		 'nullable' => false,
		 'primary' => true
		 ],
		 'ID'
		 )
		 
		 ->addColumn(
		 'category_id',
		 \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
		 null,
		 ['nullable' => false],
		 'Category Id'
		 )
		 ->addColumn(
		 'resource_id',
		 \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
		 null,
		 ['nullable' => false],
		 'Resource Id'
		 )
		 ->setComment('Category resource details');
		 $installer->getConnection()->createTable($tableResource);  
		} 
		if(version_compare($context->getVersion(), '1.0.4', '<')) {
		$table = $setup->getConnection()->newTable(
			$setup->getTable('search_course_names')
		)->addColumn(
			'course_names_id',
			\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
			null,
			['identity' => true,'nullable' => false, 'primary' => true],
			'Primary key'
		)->addColumn(
			'title',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			['nullable' => false, 'default' => ''],
			'Title'
		)->addColumn(
			'link',
			\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
			255,
			['nullable' => false, 'default' => ''],
			'Link'
		)->addColumn(
			'status',
			\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
			6,
			['nullable' => false, 'default' => '0'],
			'Status'
		)->addColumn(
			'sort_order',
			\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
			6,
			['nullable' => false, 'default' => '0'],
			'Sort Order'
		)->setComment(
			'search_course_names'
		);
		$setup->getConnection()->createTable($table);
		}

		if(version_compare($context->getVersion(), '1.0.5', '<')) {
			$table = $setup->getConnection()->newTable(
				$setup->getTable('search_course_types')
			)->addColumn(
				'course_types_id',
				\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
				null,
				['identity' => true,'nullable' => false, 'primary' => true],
				'Primary key'
			)->addColumn(
				'course_names_id',
				\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
				null,
				['nullable' => false],
				'Names Id'
			)->addColumn(
				'title',
				\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
				255,
				['nullable' => false, 'default' => ''],
				'Title'
			)->addColumn(
				'link',
				\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
				255,
				['nullable' => false, 'default' => ''],
				'Link'
			)->addColumn(
				'status',
				\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
				6,
				['nullable' => false, 'default' => '0'],
				'Status'
			)->addColumn(
				'sort_order',
				\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
				6,
				['nullable' => false, 'default' => '0'],
				'Sort Order'
			)->setComment(
				'search_course_types'
			);
			$setup->getConnection()->createTable($table);
			}
			if(version_compare($context->getVersion(), '1.0.6', '<')) {
				$predownloadtable = $setup->getConnection()->newTable(
					$setup->getTable('predownloads')
				)->addColumn(
					'predownloads_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					['identity' => true,'nullable' => false, 'primary' => true],
					'Primary key'
				)->addColumn(
					'name',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Name'
				)->addColumn(
					'email',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Email'
				)->addColumn(
					'telephone',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Telephone'
				)->addColumn(
					'referer',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Referer'
				)->addColumn(
					'subscribe_products_services',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Subscribe Products Services'
				)->addColumn(
					'subscribe_special_offers',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false, 'default' => ''],
					'Subscribe Special Offers'
				)->addColumn(
					'status',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					6,
					['nullable' => false, 'default' => '0'],
					'Status'
				)->addColumn(
					'created_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'Created At'
				)->addColumn(
					'updated_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
					'Updated At');
				$setup->getConnection()->createTable($predownloadtable);
				}
				if (version_compare($context->getVersion(), '1.0.7', '<')) {
					$predownloadtable = $setup->getConnection()->newTable(
						$setup->getTable('predownloads_referer')
					)->addColumn(
						'id',
						\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						null,
						['identity' => true, 'nullable' => false, 'primary' => true],
						'Primary key'
					)->addColumn(
						'referer',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						'2M',
						['nullable' => false, 'default' => ''],
						'Referer'
					)->addColumn(
						'email',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable' => false, 'default' => ''],
						'150'
					)->addColumn(
						'page_request',
						\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
						255,
						['nullable' => false, 'default' => ''],
						'Page request'
					)->addColumn(
						'created_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
						'Created At'
					);
					$setup->getConnection()->createTable($predownloadtable);
				}

		$installer->endSetup();
	}
}

