<?php

namespace Expedux\ProductInlineEdit\Controller\Adminhtml\Product;

class InlineEdit extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $jsonFactory;

    /**
     * @var \Magento\Catalog\Model\ProductFactory $productFactory
     */
    protected $productFactory;

    /**
    * @param \Magento\Backend\App\Action\Context $context
    * @param \Magento\Framework\Controller\Result\JsonFactory $jsonFactory
    * @param \Magento\Catalog\Model\ProductFactory $productFactory
    */

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $jsonFactory,
        \Magento\Catalog\Model\ProductFactory $productFactory
    ) {
        parent::__construct($context);
        $this->jsonFactory = $jsonFactory;
        $this->_productFactory = $productFactory;
    }

    /**
     * @return \Magento\Framework\Controller\Result\JsonFactory
     */
    public function execute()
    {
        $resultJson = $this->jsonFactory->create();
        $error = false;
        $messages = [];

        $postItems = $this->getRequest()->getParam('items', []);
        if (!($this->getRequest()->getParam('isAjax') && count($postItems))) {
            return $resultJson->setData([
                'messages' => [__('Please correct the data sent.')],
                'error' => true,
            ]);
        }
        foreach ($postItems as $value)
        {
        
            if ($value) {
            
                $productObj = $this->_productFactory->create();
                if ($value['entity_id']) {
                    $productObj->load($value['entity_id']);
                }
                $productObj->setStoreId(0);
                if(array_key_exists('name', $value)) {
                    $productObj->setName($value['name']);
                }

                if(array_key_exists('sku', $value)) {
                    $productObj->setSku($value['sku']);
                }
                
                if(array_key_exists('price', $value)) {
                    $productObj->setPrice(preg_replace('@[$€]@u', '',$value['price']));
                }

                if(array_key_exists('status', $value)) {
                    $productObj->setStatus($value['status']);
                }
               
                if(array_key_exists('qty', $value)) {
                    $productObj->setStockData(
                        array(
                            'is_in_stock' => ($value['qty'] > 0 ? 1 : 0),
                            'qty' => $value['qty']
                        )
                    );
                }

             

                try {
                    $productObj->save();
                } catch (\Magento\Framework\Model\Exception $e) {
                    $this->messageManager->addError($e->getMessage());
                }
            }
        }
        return $resultJson->setData([
            'messages' => $messages,
            'error' => $error
        ]);
    }
}