/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * @api
 */
define([
    'Magento_Ui/js/form/element/abstract'
], function (Abstract) {
    'use strict';

    return Abstract.extend({
        defaults: {
            currency_sign:'',
            // links: {
            //     value: false
            // }
        },
        initObservable: function () {
            this._super();

            return this;
        },
        getInitialValue: function () {
            var values = [this.source.get(this.dataScope), this.default],
            value;

            values.some(function (v) {
                if (v !== null && v !== undefined) {
                    value = v.replace(/[^\d.]+/g, '');
                    return true;
                }
                return false;
            });

            return this.normalizeData(value);
        }
    });
});
