define(['uiCollection'],
    function(Collection) {
        'use strict';
        return function(Collection) {
            return Collection.extend({
                defaults: {
                    active: true,
                    hasChanges: false,
                    fields: [],
                    errorsCount: 0,
                    fieldTmpl: 'ui/grid/editing/field',
                    rowTmpl: 'ui/grid/editing/row',
                    templates: {
                        fields: {
                            base: {
                                parent: '${ $.$data.record.name }',
                                name: '${ $.$data.column.index }',
                                provider: '${ $.$data.record.name }',
                                dataScope: 'data.${ $.$data.column.index }',
                                imports: {
                                    disabled: '${ $.$data.record.parentName }:fields.${ $.$data.column.index }.disabled'
                                },
                                isEditor: true
                            },
                            text: {
                                component: 'Magento_Ui/js/form/element/abstract',
                                template: 'ui/form/element/input'
                            },
                            date: {
                                component: 'Magento_Ui/js/form/element/date',
                                template: 'ui/form/element/date',
                                dateFormat: 'MMM d, y h:mm:ss a'
                            },
                            select: {
                                component: 'Magento_Ui/js/form/element/select',
                                template: 'ui/form/element/select',
                                options: '${ JSON.stringify($.$data.column.options) }'
                            },
                            price: {
                                component: 'Expedux_ProductInlineEdit/js/form/element/price',
                                template: 'ui/form/element/price',
                            },
                        }
                    },
                    ignoreTmpls: {
                        data: true
                    },
                    listens: {
                        elems: 'updateFields',
                        data: 'updateState'
                    },
                    imports: {
                        onColumnsUpdate: '${ $.columnsProvider }:elems'
                    },
                    modules: {
                        columns: '${ $.columnsProvider }',
                        editor: '${ $.editorProvider }'
                    }
                },
                createFields: function(columns) {
                    if (this.data && this.data.entity_id && this.data.type_id) {
                        if (this.data.type_id == 'configurable') {
                            columns.forEach(
                                function(column) {
                                    if (column.editor && !this.hasChild(column.index)) {
                                        if (column.index != 'price' && column.index != "special_price" && column.index != "special_from_date" && column.index != "special_to_date" && column.index != "color" && column.index != "qty") {
                                            this.initField(column);
                                        }
                                    }
                                }, this);
                        } else if (this.data.type_id == "bundle") {
                            columns.forEach(function(column) {
                                if (column.editor && !this.hasChild(column.index)) {
                                    if (column.index != "price" && column.index != "qty") {
                                        this.initField(column);
                                    }
                                }
                            }, this);
                        } else if (this.data.type_id == "virtual" || this.data.type_id == "downloadable") {
                            columns.forEach(function(column) {
                                if (column.editor && !this.hasChild(column.index)) {
                                    if (column.index != "weight") {
                                        this.initField(column);
                                    }
                                }
                            }, this);
                        } else {
                            columns.forEach(function(column) {
                                if (column.editor && !this.hasChild(column.index)) {
                                    this.initField(column);
                                }
                            }, this);
                        }
                    } else {
                        columns.forEach(function(column) {
                                if (column.editor && !this.hasChild(column.index)) {
                                    this.initField(column);
                                }
                            },
                            this);
                    }
                    return this;
                }
            });
        }
    });