<?php
namespace Expedux\PushAlert\Controller\Alert;
use Magento\Framework\Controller\Result\JsonFactory;
class Save extends \Magento\Framework\App\Action\Action
{

	
    /**
     * @var JsonFactory
     */
    protected $_resultJsonFactory;
    /**
     * View constructor.
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param Customer $customer
     * @param CustomerFactory $customerFactory  
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Customer\Model\Customer $customer,
        \Magento\Customer\Model\ResourceModel\CustomerFactory $customerFactory,            
        JsonFactory $resultJsonFactory
    )
    {
        $this->_resultJsonFactory = $resultJsonFactory;         
        $this->customer = $customer;
        $this->customerFactory = $customerFactory;
        parent::__construct($context);
    }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        try {
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
            $resultJson = $this->_resultJsonFactory->create();
            $jsonMsg = "Customer not logged In";
            $jsonStatus = true;
            $jsonAry = array();            
            if($customerSession->isLoggedIn()) {
                $customer_email = $customerSession->getCustomer()->getEmail();
                $customerId = $customerSession->getCustomer()->getId();               
                $post = $this->getRequest()->getPost();
                $subscriberId = $post['subscriber_id'];
                $customer = $this->customer->load($customerId);
                    $customerData = $customer->getDataModel();
                    $customerData->setCustomAttribute('pushalert_subs_id',$subscriberId);
                    $customer->updateData($customerData);
                    $customerResource = $this->customerFactory->create();
                    $customerResource->saveAttribute($customer, 'pushalert_subs_id');
                    $jsonMsg = "Customer pushalert details has been saved";
                    $jsonAry = array("message" => $jsonMsg, "suceess" => $jsonStatus);            
            }else{
                $jsonAry = array("message" => $jsonMsg, "suceess" => $jsonStatus);
            }
        } catch (\Exception $e) {
            $jsonMsg = "We can't submit your request, Please try again.";
            $jsonAry = array("message" => $jsonMsg, "suceess" => $jsonStatus);
        }
        $resultJson->setData($jsonAry);
        return $resultJson;
    }
}
?>
