<?php
namespace Expedux\PushAlert\Controller\Alert;
use Magento\Framework\Controller\Result\JsonFactory;
class Index extends \Magento\Framework\App\Action\Action
{

	
    /**
     * @var JsonFactory
     */
    protected $_resultJsonFactory;  
   /**
     * View constructor.
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param CollectionFactory $orderCollectionFactory  
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
        JsonFactory $resultJsonFactory
    )
    {
        $this->_resultJsonFactory = $resultJsonFactory; 
        $this->_orderCollectionFactory = $orderCollectionFactory;
        parent::__construct($context);
    }
    /**
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        try {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $resultJson = $this->_resultJsonFactory->create();
        $jsonMsg = "Customer not logged In";
        $jsonStatus = false;
        $jsonAry = array();  
        if($customerSession->isLoggedIn()) {           
            $customer_email = $customerSession->getCustomer()->getEmail();
            $customerId = $customerSession->getCustomer()->getId();
            $lastOrderId = 13010; //defined for not fetching old data
            $lastUpdatedOrderId = 0;
            $isnew = true;
            $customer_email = 'exedaccounts@jbs.cam.ac.uk';
            $customerId = 9617;

            $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
            $connection = $resource->getConnection();
            $tableName = $resource->getTableName('expedux_pushalert_info');
            $pushsql = "SELECT order_id FROM " . $tableName . " WHERE customer_id = '" . $customerId . "'";
            $pushOrderId = $connection->fetchOne($pushsql);
            if(!empty($pushOrderId)){ $lastOrderId = $pushOrderId; $isnew = false;}
            echo "fg:".$lastOrderId;
            $order_collection = $this->_orderCollectionFactory->create()
                              ->addAttributeToFilter('customer_email', $customer_email)
                              ->addAttributeToFilter('entity_id', ['gt' => $lastOrderId])
                              ->setOrder('created_at', 'desc')
                              ->setPageSize(20)
                              ->setCurPage(1); 
            $orderIds = array();   
            $skus = array(); 
            $cities =  array();
            foreach ($order_collection as $order)
               {
                   $orderIds[] = $order->getEntityId();
                   echo $deladdress_sql = "SELECT city from sales_flat_order_address_delegate WHERE order_id ='" . $order->getEntityId() . "'";
                   $deladdressArr = $connection->fetchAll( $deladdress_sql );                   
                   if (count ( $deladdressArr ) > 0) {
                        foreach ( $deladdressArr as $add ) {                
                            if(!empty($add['city']))
                            {
                                $location = strtolower($add['city']);
                                if(strlen($location) > 64) $location = substr($location,0,64);
                                $cities[] = $location;
                    
                            }                
                        }
                    }else{
                        $shippingAddress = $order->getShippingAddress();
                        $city = strtolower($shippingAddress->getCity());
                        if(strlen($city) > 64) $city = substr($city,0,64);
                        $cities [] = trim($city);
                    }
                   $items = $order->getAllItems();                  
                   foreach ($items as $itemId => $item)
                   {
                        $sku = $item->getSku();
                        if(!empty($sku))
                        {
                            $sku = str_replace('/','-',strtolower($sku));
                            $sku = preg_replace('/[^a-zA-Z0-9-]/','-', $sku);
                            if(strlen($sku) > 64) $sku = substr($sku,0,64);
                            $skus[] = trim($sku);
                        }
                   }
               } 
               print_r($orderIds);
               $skus = array_unique($skus);
               $cities = array_unique($cities);
               $cities_str = implode(',',$cities);
               if(strlen($cities_str) > 64) $cities_str = substr($cities_str,0,64);
               $skus_str = '';
               if(count($skus) > 0)
               {
                   foreach($skus as $sk)
                   {
                       $skus_str .= '"'.$sk.'":"1",';
                   }
               }      
               
               if(count($orderIds)>0){
                $lastUpdatedOrderId = $orderIds[0];
               }
               if($lastUpdatedOrderId>0){
                    if($isnew){
                        $lastUpdatedsql = "INSERT INTO " . $tableName . " (customer_id, order_id)
                        VALUES ('" . $customerId . "', '" . $lastUpdatedOrderId . "')";                    
                    }else{
                        $lastUpdatedsql = "UPDATE " . $tableName . " SET order_id = " . $lastUpdatedOrderId . "
                        WHERE customer_id = " . $customerId;
                    }
                    $connection->query($lastUpdatedsql);
               }
               $jsonMsg = "Customer details has been sent";
               $jsonStatus = true;
               $jsonAry = array("message" => $jsonMsg, "psku" => $skus_str, "pcity" => $cities_str, "suceess" => $jsonStatus);
        }else{
            $jsonAry = array("message" => $jsonMsg, "suceess" => $jsonStatus);
        }
    } catch (\Exception $e) {
        $jsonMsg = "We can't submit your request, Please try again.";
        $jsonAry = array("message" => $jsonMsg, "suceess" => $jsonStatus);
    }
    $resultJson->setData($jsonAry);
    return $resultJson;
    }
}
?>