<?php

namespace Expedux\Sales\Block\Adminhtml\Multidelegate\Create\Items;

use Magento\Framework\App\ObjectManager;
use Magento\Sales\Block\Adminhtml\Order\Create\Search\Grid\DataProvider\ProductCollection as ProductCollectionDataProvider;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{

    protected $_template = 'Expedux_Sales::widget/grid/extended.phtml';

    /**
     * Sales config
     *
     * @var \Magento\Sales\Model\Config
     */
    protected $_salesConfig;
    protected $ProductId;
    /**
     * Session quote
     *
     * @var \Magento\Backend\Model\Session\Quote
     */
    protected $_sessionQuote;

    /**
     * Catalog config
     *
     * @var \Magento\Catalog\Model\Config
     */
    protected $_catalogConfig;

    /**
     * Product factory
     *
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $_productFactory;

    /**
     * @var ProductCollectionDataProvider $productCollectionProvider
     */
    private $productCollectionProvider;

    /**
     * Core registry.
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    protected $inventoryId = null;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Backend\Helper\Data $backendHelper
     * @param \Magento\Catalog\Model\ProductFactory $productFactory
     * @param \Magento\Catalog\Model\Config $catalogConfig
     * @param \Magento\Backend\Model\Session\Quote $sessionQuote
     * @param \Magento\Sales\Model\Config $salesConfig
     * @param array $data
     * @param ProductCollectionDataProvider|null $productCollectionProvider
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Catalog\Model\Config $catalogConfig,
        \Magento\Backend\Model\Session\Quote $sessionQuote,
        \Magento\Customer\Model\Session $session,
        \Magento\Sales\Model\Config $salesConfig,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\Data\CollectionFactory $collectionFactory,
        array $data = [],
        ProductCollectionDataProvider $productCollectionProvider = null
    ) {
        $this->_productFactory = $productFactory;
        $this->_catalogConfig = $catalogConfig;
        $this->_sessionQuote = $sessionQuote;
        $this->_session = $session;
        $this->_request = $request;
        $this->_collectionFactory = $collectionFactory;
        $this->_salesConfig = $salesConfig;
        $this->_coreRegistry = $registry;
        $this->productCollectionProvider = $productCollectionProvider
        ?: ObjectManager::getInstance()->get(ProductCollectionDataProvider::class);
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * Constructor
     *
     * @return void
     */
    protected function _construct()
    {

        $existData = $this->_coreRegistry->registry('inventory_receiving_form_data');

        if ($existData && $existData->getId()) {
            $this->inventoryId = $existData->getId();
        }

        parent::_construct();
        $this->setId('invertory_receiving_create_items_grid');
        $this->setRowClickCallback(null);
        $this->setCheckboxCheckCallback(null);
        $this->setRowInitCallback('item.productGridItemInit.bind(item)');
        //$this->setDefaultSort('entity_id');
        $this->setFilterVisibility(false);
        $this->setPagerVisibility(false);
        $this->setUseAjax(true);
        if ($this->getRequest()->getParam('collapse')) {
            $this->setIsCollapsed(true);
        }
    }

    /**
     * Retrieve quote store object
     *
     * @return \Magento\Store\Model\Store
     */
    public function getStore()
    {
        return $this->_sessionQuote->getStore();
    }

    protected function _getSession()
    {
        return $this->_sessionQuote;
    }

    public function getQuote()
    {
        return $this->_getSession()->getQuote();
    }

    public function getItems()
    {
        return $this->getQuote()->getAllVisibleItems();
    }


    /**
     * Add column filter to collection
     *
     * @param \Magento\Backend\Block\Widget\Grid\Column $column
     * @return $this
     */
    protected function _addColumnFilterToCollection($column)
    {
        // Set custom filter for in product flag
        if ($column->getId() == 'in_products') {
            $productIds = $this->_getSelectedProducts();
            if (empty($productIds)) {
                $productIds = 0;
            }
            if ($column->getFilter()->getValue()) {
                $this->getCollection()->addFieldToFilter('entity_id', ['in' => $productIds]);
            } else {
                if ($productIds) {
                    $this->getCollection()->addFieldToFilter('entity_id', ['nin' => $productIds]);
                }
            }
        } else {
            parent::_addColumnFilterToCollection($column);
        }
        return $this;
    }

    /**
     * Prepare collection to be displayed in the grid
     *
     * @return $this
     */
    protected function _prepareCollection()
    {
        //print_r('dsa');exit();

        // if (!$this->dataHelper->isViewPage()) {
        $attributes = $this->_catalogConfig->getProductAttributes();
        $store = $this->getStore();

        /* @var $collection \Magento\Catalog\Model\ResourceModel\Product\Collection */
        $collection = $this->productCollectionProvider->getCollectionForStore($store);
        $collection->addAttributeToSelect(
            $attributes
        );
        $collection->addAttributeToFilter(
            'type_id',
            $this->_salesConfig->getAvailableProductTypes()
        );
        
        $carts = $this->getItems();
        $productIds = [];
        foreach ($carts  as $item){
           // $productIds
           
            $productIds[] = $item->getProductId();
        }


        $quote = $this->getQuote();

    
        if($this->_request->getParam('as_js_varname')){
       $quote->setIsMultiDelegate(1)->save();
        }

        if($quote->getIsMultiDelegate()){
          //  $collection->addFieldToFilter('entity_id', ['in' => $productIds]);

            $collection = $this->_collectionFactory->create(); 

            foreach ($carts  as $item){
             
                for ($i = 0; $i < $item->getQty(); $i++) {

                    $items = [
                        'entity_id' => $item->getProductId(),
                        'key' => $i,
                        'name' => $item->getName(),
                        'qty' => 1
                    ];

                 $varienObject = new \Magento\Framework\DataObject();
                 $varienObject->setData($items);
                 $collection->addItem($varienObject);

                }

             }

             
          

         }
        else{
            $collection->addFieldToFilter('entity_id', ['in' => []]);  
        }
       // print_r($collection->getData());exit();
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * Prepare columns
     *
     * @return $this
     */
    protected function _prepareColumns()
    {
      
        $this->addColumn(
            'entity_id',
            [
                'header' => __('ID'),
                'sortable' => false,
                'header_css_class' => 'col-id no-display',
                'column_css_class' => 'col-id no-display',
                'index' => 'entity_id',
            ]
        );


        $this->addColumn('name', ['header' => __('Product'), 'sortable' => false, 'index' => 'name']);
        
        $this->addColumn(
            'qty',
            [
                'filter' => false,
                'sortable' => false,
                'header' => __('Quantity'),
                'renderer' => \Expedux\Sales\Block\Adminhtml\Multidelegate\Create\Renderer\Qty::class,
                'name' => 'qty',
                'inline_css' => 'qty',
                'type' => 'input',
                'validate_class' => 'validate-number',
                'index' => 'qty',
            ]
        );

        $this->addColumn(
            'send_to',
            [
                'filter' => false,
                'sortable' => false,
                'header' => __('Send To'),
                'renderer' => \Expedux\Sales\Block\Adminhtml\Multidelegate\Create\Renderer\SendTo::class,
                'name' => 'send_to',
                'inline_css' => 'send_to',
                'type' => 'input',
                'validate_class' => 'validate-number',
                'index' => 'send_to',
            ]
        );


     

     
     

        return parent::_prepareColumns();
    }

    /**
     * Get grid url
     *
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl(
            'multidelegate/*/loadBlock',
            ['block' => 'items_grid', '_current' => true, 'collapse' => null]
        );
    }

    /**
     * Get selected products
     *
     * @return mixed
     */
    protected function _getSelectedProducts()
    {
        $products = $this->getRequest()->getPost('products', []);

        return $products;
    }

    /**
     * Add custom options to product collection
     *
     * @return $this
     */
    protected function _afterLoadCollection()
    {
        

        return parent::_afterLoadCollection();
    }

    // protected function getInventoryProducts()
    // {
    //     $existData = $this->_coreRegistry->registry('inventory_receiving_form_data');
    // }

}
