<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Block\Adminhtml\Multidelegate\Create\Renderer;
use Magento\Customer\Api\AddressRepositoryInterface;

/**
 * Grid select input column renderer
 *
 * @api
 * @since 100.0.2
 */
class SendTo extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer
{
   

    /**
     * @param \Magento\Backend\Block\Context $context
     * 
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Context $context,
        \Magento\Backend\Model\Session\Quote $sessionQuote,
        \Magento\Customer\Model\ResourceModel\Address\Collection $addressCollection,
        \Magento\Sales\ViewModel\Customer\AddressFormatter $customerAddressFormatter,
        AddressRepositoryInterface $addressRepository,
        array $data = []
    ) {
        $this->_sessionQuote = $sessionQuote;
        $this->_addressCollection = $addressCollection;
        $this->_customerAddressFormatter = $customerAddressFormatter;
        $this->addressRepository = $addressRepository;
        parent::__construct($context, $data);
    }

    /**
     * Get options from column
     *
     * @return array
     */
    protected function _getOptions()
    {
        return $this->getColumn()->getOptions();
    }

    protected function _getSession()
    {
        return $this->_sessionQuote;
    }

    public function getCustomerId()
    {
        return $this->_getSession()->getCustomerId();
    }


    /**
     * Renders grid column
     *
     * @param   \Magento\Framework\DataObject $row
     * @return  string
     */
    public function render(\Magento\Framework\DataObject $row)
    {

        $addressArray = [];
        if ($this->getCustomerId()) :
            $addressArray = $this->_addressCollection->setCustomerFilter([$this->getCustomerId()])->toArray();
        endif;

        $firstAddressId = '';
        if ($this->getCustomerId()) :
            $firstAddressId = $this->_addressCollection->setCustomerFilter([$this->getCustomerId()])->getFirstItem()->getId();
        endif;
       
        $name = $this->getColumn()->getName() ? $this->getColumn()->getName() : $this->getColumn()->getId();
       
        $html ='<div class="admin__field admin__field-select-from-existing-address">';
        $html .='<div class="admin__field-control">';
       
        $html .= '<select class="admin__control-select address-delegate required-entry" id="'.$this->escapeHtml($name).$row->getData('entity_id').'_'.$row->getData('key').'" name=multidelegate['.$row->getData('entity_id').']['.$row->getData('key').'][sendto] data-entityid='.$row->getData('entity_id').' data-key='.$row->getData('key').'>';
       
        $html .='<option value=""> '. $this->escapeHtml(__('Add New Address'))  .' </option>';
        
        foreach ($addressArray as $addressId => $address) {
            $selected = '';

            $addressData = $this->addressRepository->getById($addressId);
            if($addressData->getCustomAttribute('delegate_email')){
                $address['delegate_email'] = $addressData->getCustomAttribute('delegate_email')->getValue();
            }
            
        
        
            $html .= '<option value="' . $this->escapeHtmlAttr($addressId) . '" ';
           
            if ($addressId == $firstAddressId) {
                $html .= ' selected="selected"';
            }

            $html .= '>' . $this->escapeHtml($this->_customerAddressFormatter->getAddressAsString($address)) . '</option>' . "\n";

        }
        $html .= '</select>';
        $html .= '</div></div>';
        

        return $html;
    }
}