<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Expedux\Sales\Block\Adminhtml\Order\View;
use Magento\Sales\Api\Data\OrderAddressInterfaceFactory;


class Info extends \Magento\Sales\Block\Adminhtml\Order\View\Info
{


    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Sales\Helper\Admin $adminHelper,
        \Magento\Customer\Api\GroupRepositoryInterface $groupRepository,
        \Magento\Customer\Api\CustomerMetadataInterface $metadata,
        \Magento\Customer\Model\Metadata\ElementFactory $elementFactory,
        \Magento\Sales\Model\Order\Address\Renderer $addressRenderer,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        OrderAddressInterfaceFactory $addressFactory,
        array $data = []
    ) {
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->addressFactory = $addressFactory;
        parent::__construct($context, $registry, $adminHelper,$groupRepository,$metadata,$elementFactory,$addressRenderer, $data);
    }

    

    public function getMultiDelegateShippingAddress()
    {

        $orderAddressDelegate = $this->orderAddressDelegate->create()->getCollection()
        ->addFieldToFilter('order_id', $this->getOrder()->getId());

        return $orderAddressDelegate;
    }

    public function getCustomFormatAddress($value)
    {

    $addressData = [
        'region'     => $value['region'],
        'region_id'     => $value['region_id'],
        'postcode'   => $value['postcode'],
        'lastname'   => $value['lastname'],
        'street'     => $value['street'],
        'city'       => $value['city'],
        'email'      => $value['email'],
        'telephone'  => $value['telephone'],
        'country_id' => $value['country_id'],
        'firstname'  => $value['firstname'],
        'company'    => $value['company'],
        'delegate_email' => $value['delegate_email']
    ];

        $address = $this->addressFactory->create(['data' => $addressData]);
        $formattedAddress = $this->addressRenderer->format($address, 'html');

        return (string) $formattedAddress;

    }
}