<?php
namespace Expedux\Sales\Controller\Adminhtml\Multidelegate;

use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\RawFactory;

class LoadBlock extends \Magento\Backend\App\Action
{

    protected $resultRawFactory;

    public function __construct(
        Action\Context $context,
        PageFactory $resultPageFactory,
        RawFactory $resultRawFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->resultRawFactory = $resultRawFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $request = $this->getRequest();
       
        $asJson = $request->getParam('json');
        $block = $request->getParam('block');
        $resultPage = $this->resultPageFactory->create();
        if ($asJson) {
            
            $resultPage->addHandle('multidelegate_load_block_json');
        } else {
            $resultPage->addHandle('multidelegate_load_block_plain');
        }
   
        if ($block) {
            $blocks = explode(',', $block);
             foreach ($blocks as $block) {

                $resultPage->addHandle('multidelegate_load_block_' . $block);
            }
        }
        
        $result = $resultPage->getLayout()->renderElement('content');
     
        if ($request->getParam('as_js_varname')) {
            if (is_scalar($result)) {
                return $this->resultRawFactory->create()->setContents($result);
            }
        }
        return $this->resultRawFactory->create()->setContents($result);
    }
}
