<?php
namespace Expedux\Sales\Controller\Adminhtml\Multidelegate;

use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Serialize\Serializer\Json;

class SaveAddress extends \Magento\Backend\App\Action
{

    public function __construct(
        Action\Context $context,
        \Magento\Customer\Api\AddressRepositoryInterface $addressRepository,
        \Magento\Customer\Api\Data\AddressInterfaceFactory $addressDataFactory,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Sales\ViewModel\Customer\AddressFormatter $customerAddressFormatter,
        \Magento\Customer\Model\ResourceModel\Address\Collection $addressCollection,
        \Magento\Customer\Api\Data\RegionInterfaceFactory $regionFactory,
        \Magento\Directory\Model\RegionFactory $regFactory,
        \Magento\Backend\Model\Session\Quote $quoteSession,
        \Magento\Checkout\Model\Session $checkoutSession,
        Json $serializer
    ) {
        $this->addressRepository = $addressRepository;
        $this->addressDataFactory = $addressDataFactory;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_customerAddressFormatter = $customerAddressFormatter;
        $this->_addressCollection = $addressCollection;
        $this->regionFactory = $regionFactory;
        $this->regFactory = $regFactory;
        $this->_quoteSession = $quoteSession;
        $this->checkoutSession = $checkoutSession;
        $this->serializer = $serializer;
        parent::__construct($context);
    }

    public function execute()
    {
      
        // if(strpos('newaddress-1655402492', "newaddress") !== false){
        //     echo "das";
        // }
        // exit();
        $request = $this->getRequest();
        $addressData = $request->getParam('order_new');
        
       $key = 'newaddress-'.time();
        //echo time();exit();
      
        $data = $addressData['shipping_address'];
        $value = $this->serializer->unserialize($request->getParam('product'));
     
        // print_r($request->getParams());exit();


        //print_r($value);exit();

        $requestData = $this->checkoutSession->getMultiDelegateAddress();
        $saveValue = [];
        if($requestData){

            foreach($value as $val){

            $requestData[$val['entityid']][$val['key']][$key]['delegate_email'] = $data['delegate_email'];
            $requestData[$val['entityid']][$val['key']][$key]['prefix'] = $data['prefix'];
            $requestData[$val['entityid']][$val['key']][$key]['firstname'] = $data['firstname'];
            $requestData[$val['entityid']][$val['key']][$key]['middlename'] = $data['middlename'];
            $requestData[$val['entityid']][$val['key']][$key]['lastname'] = $data['lastname'];
            $requestData[$val['entityid']][$val['key']][$key]['suffix'] = $data['suffix'];
            $requestData[$val['entityid']][$val['key']][$key]['company'] = $data['company'];
            $requestData[$val['entityid']][$val['key']][$key]['street'] = $data['street'];
            $requestData[$val['entityid']][$val['key']][$key]['city'] = $data['city'];
            $requestData[$val['entityid']][$val['key']][$key]['region'] = $data['region'];
            if(isset($data['region_id'])){
                $requestData[$val['entityid']][$val['key']][$key]['region_id'] = $data['region_id'];
            }
            $requestData[$val['entityid']][$val['key']][$key]['postcode'] = $data['postcode'];
            $requestData[$val['entityid']][$val['key']][$key]['country_id'] = $data['country_id'];
            $requestData[$val['entityid']][$val['key']][$key]['telephone'] = $data['telephone'];
            $requestData[$val['entityid']][$val['key']][$key]['fax'] = $data['fax'];
            }
        }else{
            $requestData = [];
            foreach($value as $val){

                

                $requestData[$val['entityid']][$val['key']][$key]['delegate_email'] = $data['delegate_email'];
                $requestData[$val['entityid']][$val['key']][$key]['prefix'] = $data['prefix'];
                $requestData[$val['entityid']][$val['key']][$key]['firstname'] = $data['firstname'];
                $requestData[$val['entityid']][$val['key']][$key]['middlename'] = $data['middlename'];
                $requestData[$val['entityid']][$val['key']][$key]['lastname'] = $data['lastname'];
                $requestData[$val['entityid']][$val['key']][$key]['suffix'] = $data['suffix'];
                $requestData[$val['entityid']][$val['key']][$key]['company'] = $data['company'];
                $requestData[$val['entityid']][$val['key']][$key]['street'] = $data['street'];
                $requestData[$val['entityid']][$val['key']][$key]['city'] = $data['city'];
                $requestData[$val['entityid']][$val['key']][$key]['region'] = $data['region'];
                
                if(isset($data['region_id'])){
                    $requestData[$val['entityid']][$val['key']][$key]['region_id'] = $data['region_id'];
                }
                
                $requestData[$val['entityid']][$val['key']][$key]['postcode'] = $data['postcode'];
                $requestData[$val['entityid']][$val['key']][$key]['country_id'] = $data['country_id'];
                $requestData[$val['entityid']][$val['key']][$key]['telephone'] = $data['telephone'];
                $requestData[$val['entityid']][$val['key']][$key]['fax'] = $data['fax'];

            }
           
           // print_r($saveValue);exit();

          
        }

       // print_r($requestData);exit();
        $this->checkoutSession->setMultiDelegateAddress($requestData);


            

            $customer = $this->_quoteSession->getQuote()->getCustomer();

            if ($customer->getId()) {


                if(isset($data['region_id'])){
                    $region = $this->regFactory->create();
                    $region->load($data['region_id']);
                    $regionId = $region->getRegionId();
                }
                
        
                    if(!isset($regionId)){
                        $region = $this->regionFactory->create()->setRegion($data['region']);
                    }
        
                    unset($data['region']);
        


            $address = $this->addressDataFactory->create(['data' => $data])->setCustomerId($this->_quoteSession->getQuote()->getCustomerId());
      
            if(isset($regionId)){
                $address->setRegionId($regionId);
            }else{
                $address->setRegion($region);
            }


    $address->setCustomAttribute('delegate_email', $data['delegate_email']); 

    
     $addressId = $this->addressRepository->save($address);

     $addressArray = [];
     $addressArray = $this->_addressCollection
                    ->setCustomerFilter([$this->_quoteSession->getQuote()->getCustomerId()])
                    ->addFieldToFilter('entity_id', ['in' =>$addressId->getId()])
                    ->toArray();
                    

    $addd = '';
    foreach($addressArray as $ad){
        $addd = $ad;
        $addressRepository = $this->addressRepository->getById($ad['entity_id']);
        if($addressRepository->getCustomAttribute('delegate_email')){
            $addd['delegate_email'] = $addressRepository->getCustomAttribute('delegate_email')->getValue();
        }
    }
       // print_r($adData->toArray()());exit();
       $response['success'] =$this->_customerAddressFormatter->getAddressAsString($addd);
            $response['key'] =$address->getId();

}else{
//print_r($data);exit();

if(isset($data['region_id'])){
    $region = $this->regFactory->create();
    $region->load($data['region_id']);
    $data['region'] = $region->getName();

}


$response['success'] =$this->_customerAddressFormatter->getAddressAsString($data);
$response['key'] =$key;



}



       $result = $this->resultJsonFactory->create();
       return $result->setData($response);
    }

}