<?php

namespace Expedux\Sales\Controller\Adminhtml\Order;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\ResourceConnection;


class ReviewReq extends \Magento\Backend\App\Action
{

    public $resultPageFactory;

    public function __construct(
        Context $context,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Magento\Customer\Model\CustomerExtractor $customerExtractor,
        \Magento\Customer\Api\AccountManagementInterface $accountManagement,
        \Magento\Customer\Model\Customer $customer,
        \Magento\Sales\Model\Order $order,
        \Magento\Customer\Model\AddressFactory $addressFactory,
        ResourceConnection $resource,
		\Magento\Catalog\Helper\Image $image,
		\Reviewscouk\Reviews\Model\Api $api,
		\Reviewscouk\Reviews\Helper\Config $config,
        \Magento\Backend\Model\Auth\Session $authSession,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->orderRepository = $orderRepository;
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->_productRepository = $productRepository;
        $this->customerExtractor  = $customerExtractor;
		$this->accountManagement  = $accountManagement;
        $this->customer = $customer;
        $this->_order = $order;
        $this->_resource = $resource;
		$this->imageHelper = $image;
		$this->apiModel = $api;
		$this->configHelper = $config;
        $this->authSession = $authSession;
        $this->addressFactory = $addressFactory;
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute()
    {
       
        $resultPage = $this->resultPageFactory->create();
      
        $resultRedirect = $this->resultRedirectFactory->create();
        
        // if($this->getRequest()->getParam('order_id'))
    	// {
        //     $orderId = $this->getRequest()->getParam('order_id');
        //     $order = $this->orderRepository->get($orderId);

           
        // }	
		$connection = $this->_resource->getConnection();
        $dbWrite = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
		$dbRead = $this->_resource->getConnection();
		
		$orderId  = $this->getRequest()->getParam('order_id');
		
		$order = $this->orderRepository->get($orderId);
		
		$magento_store_id = $order->getStoreId();
		
		if($this->configHelper->getApiKey($magento_store_id)){

		// $rstore_id = $this->_scopeConfig->getValue('reviewscouk_reviews_settings/api/reviews_store_id', $magento_store_id);
		// $apikey = $this->_scopeConfig->getValue('reviewscouk_reviews_settings/api/reviews_api_key', $magento_store_id);
		$template_id ='17584';
		
		
		
		$address_sql = "SELECT entity_id,firstname, lastname, street, city, telephone, country_id, postcode, company, product_id, qty, customer_address_id, fax, region_id, region, prefix,delegate_email from sales_flat_order_address_delegate WHERE order_id ='" . $orderId . "'";
   		$addressArr = $dbRead->fetchAll ($address_sql);
		
		if (count ( $addressArr ) > 0) 
		{
			
		
			foreach ( $addressArr as $add ) {
			
		$post_params = array();
		$p =  array();
	
					if (!empty($add['customer_address_id'])){
						$customerName = $add['firstname'].' '.$add['lastname'];
						$customerEmail = $add['delegate_email'];
					}
					else 
					{
						$customerName = $order->getShippingAddress ()->getFirstname ().' '.$order->getShippingAddress ()->getLastname ();
						$customerEmail = $order->getShippingAddress()->getDelegateEmail();
					}
					
			$item = $this->_productRepository->getById ( $add ['product_id'] );
			
			
			// $thumbImg = $item->getThumbnail();
			// 		if(!empty($thumbImg))
			// 		{
			// 		$image = Mage::getModel('catalog/product_media_config')->getMediaUrl($item->getThumbnail());
			// 		}
			// 		else
			// 		{
			// 			$image = '';
			// 		}
					
					$imageUrl = $this->imageHelper->init($item, 'product_page_image_large')->getUrl();
					$p[]   = array(
						'image'   => $imageUrl,
						'id'      => $item->getId(),
						'sku'     => $item->getSku(),
						'name'    => $item->getName(),
						'pageUrl' => $item->getProductUrl()
					);


					
				// $post_params['store'] = $rstore_id;
				// $post_params['apikey'] = $apikey;
				
				// $post_params['order_id'] = $order->getRealOrderId();
				// $post_params['email']    = $customerEmail;
				// $post_params['name']     = $customerName;
				// $post_params['delay']    = 0;
				// $post_params['template_id']    = $template_id;
				// $post_params['products'] = $p;


			
			$productResponse = $this->apiModel->apiPost('/invitation', [
				'source'       => 'magento',
				'name'         => $customerName,
				'email'        => trim($customerEmail),
				'template_id'  => $template_id,
				'delay'        => 0,
				'order_id'     => $order->getRealOrderId(),
				'country_code' => $order->getShippingAddress()->getCountryId(),
				'products'     => $p
			], $magento_store_id);

				
				
				//$res = $this->reviewPost($post_params,$order);
				
			//	echo '<pre>';
			//print_r($res);
			//print_r($post_params); 
				
			}
			
			//exit;
		}
		else
		{
			
		$items = $order->getAllVisibleItems();
		$post_params = array();
		$p =  array();
				foreach ($items as $item)
				{
					// Load the product
					// $item = Mage::getModel('catalog/product')->load($item->getProductId());

					// // If product is part of a grouped product, use the grouped product details.
					// $enabled = Mage::getStoreConfig('reviewscouk_reviews_settings/advanced/reviews_use_group_product_sku', Mage::app()->getStore());

					// if ($enabled)
					// {
					// 	// If product is part of a grouped product, use the grouped product details.
					// 	$parentIds = Mage::getModel('catalog/product_type_grouped')->getParentIdsByChild($item->getId());
					// 	if (!empty($parentIds))
					// 	{
					// 		$item = Mage::getModel('catalog/product')->load($parentIds[0]);
					// 	}
					// }


					if ($this->configHelper->isUsingGroupSkus($magento_store_id)) {
                        // If product is part of a configurable product, use the configurable product details.
                        if ($item->getProduct()->getTypeId() == 'simple' || $item->getProduct()->getTypeId() == \Magento\ConfigurableProduct\Model\Product\Type\Configurable::TYPE_CODE) {
                            $productId = $item->getProduct()->getId();
                            //$model = $this->productModel->create();
                            $item = $this->_productRepository->getById($productId);
                        }
                    }

					// Prepare data
					
					// $thumbImg = $item->getThumbnail();
					// if(!empty($thumbImg))
					// {
					// $image = Mage::getModel('catalog/product_media_config')->getMediaUrl($item->getThumbnail());
					// }
					// else
					// {
					// 	$image = '';
					// }

					$imageUrl = $this->imageHelper->init($item, 'product_page_image_large')->getUrl();

					$p[]   = array(
						'image'   => $imageUrl,
						'id'      => $item->getId(),
						'sku'     => $item->getSku(),
						'name'    => $item->getName(),
						'pageUrl' => $item->getProductUrl()
					);
				}

			// 	echo '<pre>';
			// print_r($p);exit();
					
				// $post_params['store'] = $rstore_id;
				// $post_params['apikey'] = $apikey;
				
			$customer = $this->customer->load($order->getCustomerId());
			$custEmail = $customer->getEmail();
			$shiperemail = $order->getShippingAddress()->getDelegateEmail();
			
			$customerName = $order->getShippingAddress ()->getFirstname ().' '.$order->getShippingAddress ()->getLastname ();
			
			if(!empty($shiperemail))
			{
				
			
			if($custEmail != $shiperemail)
			{
		    $customerEmail = $order->getShippingAddress()->getDelegateEmail();
			}
			else
			{
			$customerEmail = $customer->getEmail();	
			}
			
			}
			else
			{
			 $customerEmail = $customer->getEmail();	
			}
				
				// $post_params['order_id'] = $order->getRealOrderId();
				// $post_params['email']    = $customerEmail;
				// $post_params['name']     = $customerName;
				// $post_params['delay']    = 0;
				// $post_params['template_id']    = $template_id;
				// $post_params['products'] = $p;	
			
			//$res = $this->reviewPost($post_params,$order);

			$productResponse = $this->apiModel->apiPost('/invitation', [
				'source'       => 'magento',
				'name'         => $customerName,
				'email'        => trim($customerEmail),
				'template_id'  => $template_id,
				'delay'        => 0,
				'order_id'     => $order->getRealOrderId(),
				'country_code' => $order->getShippingAddress()->getCountryId(),
				'products'     => $p
			], $magento_store_id);


			//echo '<pre>';
			//print_r($res);
			//print_r($productResponse); exit;		
			
		}
					
		
		$res = $this->addStatusMessage($productResponse, "Product Review Invitation");

		if($res == true)
		{
			$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $authSession = $objectManager->create(\Magento\Backend\Model\Auth\Session::class);
            $adminName = $authSession->getUser()->getName();

			      //  $adminName = Mage::getSingleton('admin/session')->getUser()->getFirstname()." ".Mage::getSingleton('admin/session')->getUser()->getLastname();
					
					$orderComments = 'Review request sent by '.$adminName .' on '.date("Y-m-d H:i:s");
					$order->addStatusHistoryComment($orderComments);
					$order->setIsVisibleOnFront(false);
					$order->setIsCustomerNotified(false);
					$order->save();

					//$lmsadminorder = $this->_order->load($orderId);
                $order->setReviewRequest(1)->save();

					
					// $up_qry = "UPDATE ".$prefix."sales_flat_order SET review_request ='1' WHERE entity_id = '".$orderId."'";
					// $dbWrite->query($up_qry);
					
					$this->messageManager->addSuccess('Review request submitted successfully');
		}
		else
		{
			$this->messageManager->addError('Error in Review request submit');	
		}
					
			
	}else{
		$this->messageManager->addError('Please add api key on Reviews.co.uk');	
	}
				//echo '<pre>';
				//print_r($res);
				//print_r($json_res); exit;
				
				//$this->_redirect('*/*/view', array('order_id'=>$orderId));	

        return $resultRedirect->setPath('sales/order/view', ['order_id' => $this->getRequest()->getParam('order_id')]);
    }

    public function reviewPost($post_params,$order)
    {
		
		$magento_store_id = $order->getStoreId();
		$orderId = $order->getId();	
		
		$rstore_id = Mage::getStoreConfig('reviewscouk_reviews_settings/api/reviews_store_id', $magento_store_id);
		$apikey = Mage::getStoreConfig('reviewscouk_reviews_settings/api/reviews_api_key', $magento_store_id);
		
		// Send product request
				$product_url_string = 'https://api.reviews.co.uk/product/invitation';
				
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $product_url_string);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_HEADER, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array(
					"store:" . $rstore_id,
					"apikey:" . $apikey,
					"Content-Type: application/json"
				));
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_params));
				$res = curl_exec($ch);
							
				$json_res = Mage::helper('core')->jsonEncode($res);			
				
				$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
				curl_close($ch);
				
				//print_r($res); exit;
				if($http_code == "200")
				{
					return true;
				}
				else
				{
					return false;
					
				}
				
				
	}


	public function addStatusMessage($object, $task)
    {
        $object = json_decode($object);

        if (isset($object->status) && $object->status == 'error') {
			return false;
            //$this->messageInterface->addError($task . ' Error: ' . $object->message);
        }

		return true;
    }
   
    
}
