<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Model;

use Magento\ConfigurableProduct\Model\ResourceModel\Attribute\OptionSelectBuilderInterface;
use Magento\Eav\Model\Entity\Attribute\AbstractAttribute;
use Magento\Framework\App\ScopeResolverInterface;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable\Attribute;
use Magento\Framework\DB\Select;

/**
 * Sales Order Invoice PDF model
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class AttributeOptionProvider
{
   

     public function afterGetAttributeOptions(
        \Magento\ConfigurableProduct\Model\AttributeOptionProvider $subject, $result,
        AbstractAttribute $superAttribute, 
        $productId
        
    ) {

    $sortByOptionTitle=false;
    foreach ($result as $key => $value) {

        if (isset($value['attribute_code']))
                {
                    if ($value['attribute_code']=='dates')
                    {       $date = explode("-",$value['option_title']);
                        if(isset($date[0])){
                            $result[$key]['option_title_format'] =  str_replace('/', '-',$date[0]);
                        
                            $sortByOptionTitle=true;
                        }
                        
                    }
            }

        }

        if ($sortByOptionTitle)
        {
            usort($result, function($a, $b) {
                return strtotime($a['option_title_format']) - strtotime($b['option_title_format']);
            });
        }

        return $result;
    }   

}