<?php

namespace Expedux\Sales\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderAddressInterfaceFactory;

class AddMultiDelegateVariable implements ObserverInterface
{
    
    private $order = null;

    public function __construct(
        \Magento\Sales\Model\Order\Address\Renderer $addressRenderer,
        OrderAddressInterfaceFactory $addressFactory,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate
    ) {
        $this->addressRenderer = $addressRenderer;
        $this->addressFactory = $addressFactory;
        $this->_productRepository = $productRepository;
        $this->orderAddressDelegate = $orderAddressDelegate;
    }

    public function execute(Observer $observer)
    {
        $transportObject = $observer->getEvent()->getData('transportObject');
        $this->order = $transportObject->getOrder();

        $transportObject['isnot_multi_delegate'] = 1;
        $transportObject['delegate_addresses_html'] = 0;
       if ($this->order !== null && $this->order->getIsMultiDelegate()) {
            $this->getMultiDelegateVariables($transportObject);
       }
    }

    private function getMultiDelegateVariables($transportObject)
    {
        /** @var OrderInterface $order */
        $order = $this->order;

        $orderAddressDelegate = $this->orderAddressDelegate->create()->getCollection()
        ->addFieldToFilter('order_id', $order->getId());
        $delegateAddressesBlockHtml = '';
        foreach($orderAddressDelegate->getData() as $orderAddressDelegateData){
            $product = $this->_productRepository->getById($orderAddressDelegateData['product_id']);
            $delegateAddressesBlockHtml .= $this->getCustomFormatAddress($orderAddressDelegateData);
            $delegateAddressesBlockHtml .='<p><span style="font-weight:bold;">Product Name:</span><br />'. $product->getName().'</p>';
        }

        $transportObject['isnot_multi_delegate'] = 0;
        $transportObject['delegate_addresses_html'] = $delegateAddressesBlockHtml;
    }


    public function getCustomFormatAddress($value)
    {

    $addressData = [
        'region'     => $value['region'],
        'region_id'     => $value['region_id'],
        'postcode'   => $value['postcode'],
        'lastname'   => $value['lastname'],
        'street'     => $value['street'],
        'city'       => $value['city'],
        'email'      => $value['email'],
        'telephone'  => $value['telephone'],
        'country_id' => $value['country_id'],
        'firstname'  => $value['firstname'],
        'company'    => $value['company'],
        'delegate_email' => $value['delegate_email']
    ];

        $address = $this->addressFactory->create(['data' => $addressData]);
        $formattedAddress = $this->addressRenderer->format($address, 'html');

        return (string) $formattedAddress;

    }
}
