<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Observer;

use Magento\Framework\Event\ObserverInterface;

/**
 * Gift Message Observer Model
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class CheckoutSubmit implements ObserverInterface
{
    /**
     * Gift message message
     *
     * @var \Magento\GiftMessage\Helper\Message|null
     */
    protected $_giftMessageMessage = null;

    /**
     * @var \Magento\GiftMessage\Model\MessageFactory
     */
    protected $_messageFactory;

    /**
     * @param \Magento\GiftMessage\Model\MessageFactory $messageFactory
     * @param \Magento\GiftMessage\Helper\Message $giftMessageMessage
     */
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate
    ) {
        $this->request = $request;
        $this->authSession = $authSession;
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
        $this->orderAddressDelegate = $orderAddressDelegate;
    }

    /**
     * Duplicates giftmessage from order item to quote item on import or reorder
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        // $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
        // $logger = new \Zend\Log\Logger();
        // $logger->addWriter($writer);
        // $logger->info('CheckoutSubmit');
       // $logger->info($this->request->getParams());
       
       $order = $observer->getEvent()->getData('order');

      // $logger->info($order->getId());

       $quote = $observer->getEvent()->getData('quote');
       
       $orderShippingAddress = $order->getShippingAddress();
       if($orderShippingAddress){
            $order->getShippingAddress()->setDelegateEmail($quote->getShippingAddress()->getDelegateEmail());
       }
       
       $orderBillingAddress = $order->getBillingAddress();
       if($orderBillingAddress){
            $order->getBillingAddress()->setDelegateEmail($quote->getBillingAddress()->getDelegateEmail());
        }

       //$logger->info($quote->getIsMultiDelegate());

       $adminuser = $this->authSession->getUser();

       $order->setData('admin_id', $adminuser->getId())
       ->setData('admin_username', $adminuser->getEmail())
       ->setData('admin_name', $adminuser->getName())
    ->setData('is_multi_delegate', $quote->getIsMultiDelegate())->save();


    $orderAddressDelegate = $this->orderAddressDelegate->create();

    $multishippingQuoteAddressCollection = $this->multishippingQuoteAddress->create()->getCollection()
    ->addFieldToFilter('quote_id', $order->getQuoteId());

    foreach ($multishippingQuoteAddressCollection as $key => $value) {

        $saveValue = [
            'order_id' => $order->getId(),
            'item_id' => $value->getItemId(),
            'product_id' => $value->getProductId(),
            'qty' => $value->getQty(),
            'customer_address_id' => $value->getCustomerAddressId(),
            'customer_id' => $value->getCustomerId(),
            'save_in_address_book' => 1,
            'address_type' => 'shipping',
            'email' => 'email',
            'prefix' => $value->getPrefix(),
            'firstname' => $value->getFirstname(),
            'middlename' => $value->getMiddlename(),
            'lastname' => $value->getLastname(),
            'suffix' => $value->getSuffix(),
            'company' => $value->getCompany(),
            'street' => $value->getStreet(),
            'city' => $value->getCity(),
            'region' => $value->getRegion(),
            'region_id' => $value->getRegionId(),
            'postcode' => $value->getPostcode(),
            'country_id' => $value->getCountryId(),
            'telephone' => $value->getTelephone(),
            'fax' => $value->getFax(),
            'delegate_email' => $value->getDelegateEmail(),
            'is_join_send' => 0
            
        ];

        $orderAddressDelegate->setData($saveValue)->save();

    }

    //    echo "das";exit();

      //  return $this;
    }
}
