<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\QuoteFactory; 

/**
 * Gift Message Observer Model
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class OrderSave implements ObserverInterface
{
  
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        QuoteFactory $quoteFactory
    ) {
        $this->request = $request;
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->quoteFactory = $quoteFactory;
    }

    /**
     * Duplicates giftmessage from order item to quote item on import or reorder
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
        $logger = new \Zend\Log\Logger();
        $logger->addWriter($writer);
        $logger->info('OrderSave');

       // $quote->getId()

       $order = $observer->getEvent()->getData('order');
      // $quote = $observer->getEvent()->getData('quote');
       
      $quote = $this->quoteFactory->create()->load($order->getQuoteId());
   

    //$order->setIsMultiDelegate($quote->getIsMultiDelegate())->save();


    //$order->setData('is_multi_delegate', $quote->getIsMultiDelegate())->save();
   // echo $quote->getIsMultiDelegate();echo "Das";exit();
   
       

       return $this;
    }
}
