<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Api\AddressRepositoryInterface;

/**
 * Gift Message Observer Model
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class SalesEventOrderToQuoteObserver implements ObserverInterface
{
    /**
     * Gift message message
     *
     * @var \Magento\GiftMessage\Helper\Message|null
     */
    protected $_giftMessageMessage = null;

    /**
     * @var \Magento\GiftMessage\Model\MessageFactory
     */
    protected $_messageFactory;

    /**
     * @param \Magento\GiftMessage\Model\MessageFactory $messageFactory
     * @param \Magento\GiftMessage\Helper\Message $giftMessageMessage
     */
    public function __construct(
        \Magento\GiftMessage\Model\MessageFactory $messageFactory,
        \Magento\GiftMessage\Helper\Message $giftMessageMessage,
        \Magento\Backend\Model\Session $session,
        AddressRepositoryInterface $addressRepository
    ) {
        $this->_messageFactory = $messageFactory;
        $this->_giftMessageMessage = $giftMessageMessage;
        $this->_session = $session;
        $this->addressRepository = $addressRepository;
    }

    /**
     * Duplicates giftmessage from order to quote on import or reorder
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {  
    
        $delegateEmail = '';
        $addressId = $observer->getEvent()->getQuote()->getBillingAddress()->getCustomerAddressId();
        if($addressId){
            $addressData = $this->addressRepository->getById($addressId);
            if($addressData){
                if($addressData->getCustomAttribute('delegate_email')){
                    $delegateEmail = $addressData->getCustomAttribute('delegate_email')->getValue();
                }
            }
            
          }

        $observer->getEvent()->getQuote()->getBillingAddress()->setDelegateEmail($delegateEmail);
        
        $delegateEmail = '';
        $addressId = $observer->getEvent()->getQuote()->getShippingAddress()->getCustomerAddressId();
        if($addressId){
            $addressData = $this->addressRepository->getById($addressId);
            if($addressData){
                if($addressData->getCustomAttribute('delegate_email')){
                    $delegateEmail = $addressData->getCustomAttribute('delegate_email')->getValue();
                }
            }
            
        }

        $observer->getEvent()->getQuote()->getShippingAddress()->setDelegateEmail($delegateEmail);

         return $this;
    }
}
