<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Sales\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Api\AddressRepositoryInterface;

/**
 * Gift Message Observer Model
 *
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class SalesEventQuoteSubmitBeforeObserver implements ObserverInterface
{
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        AddressRepositoryInterface $addressRepository,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Customer\Api\Data\AddressInterfaceFactory $addressDataFactory,
        \Magento\Customer\Model\ResourceModel\Address\Collection $addressCollection,
        \Magento\Customer\Api\Data\RegionInterfaceFactory $regionFactory,
        \Magento\Directory\Model\RegionFactory $regFactory,
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress
    ) {
        $this->request = $request;
        $this->addressRepository = $addressRepository;
        $this->checkoutSession = $checkoutSession;
        $this->addressDataFactory = $addressDataFactory;
        $this->_addressCollection = $addressCollection;
        $this->regionFactory = $regionFactory;
        $this->regFactory = $regFactory;
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
    }

    /**
     * Set gift messages to order from quote address
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        //$observer->getEvent()->getOrder()->setGiftMessageId($observer->getEvent()->getQuote()->getGiftMessageId());

        // $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
        // $logger = new \Zend\Log\Logger();
        // $logger->addWriter($writer);
        // $logger->info($observer->getEvent()->getQuote()->getData());
        // $logger->info('new1');
        
       // $logger->info($this->request->getParams());
       // echo "<pre>";
        $quote = $observer->getEvent()->getQuote();
        //print_r($this->request->getParam('multidelegate_address')['shipping_address']);exit();
        $params = $this->request->getParams();
       
       // $logger->info($params);

       // echo "dsa";exit();

        if(isset($params['multi-delegate']) && $params['multi-delegate'] == 1){
            
            $quote = $observer->getEvent()->getQuote();

          //  $itemsArray = $addressInformation->getExtensionAttributes()->getMultishippingItems();
          $multishippingAddress = $this->multishippingQuoteAddress->create();
                foreach ($params['multidelegate'] as $productId => $multidelegateValue) {


                

                  foreach($multidelegateValue as $key => $value){
                  //print_r($value);exit();


                  $level = '100'; // use one of: 100, 200, 250, 300, 400, 500, 550, 600
                  \Magento\Framework\App\ObjectManager::getInstance()
                      ->get('Psr\Log\LoggerInterface')
                      ->log($level, print_r($params, true));
           
                   $saveValue = [];
                   $addressSave = false;
                   if(strpos($value['sendto'], "newaddress") !== false){


                    $shippingAddress = $this->request->getParam('order_new')['shipping_address'];

                    $requestData = $this->checkoutSession->getMultiDelegateAddress();


                    $level = '100'; // use one of: 100, 200, 250, 300, 400, 500, 550, 600
                    \Magento\Framework\App\ObjectManager::getInstance()
                        ->get('Psr\Log\LoggerInterface')
                        ->log($level, print_r($shippingAddress, true));

                        \Magento\Framework\App\ObjectManager::getInstance()
                        ->get('Psr\Log\LoggerInterface')
                        ->log($level, print_r($requestData, true));
             
                       // echo "das";exit();
                    if(isset($requestData[$productId][$key][$value['sendto']])){

                      $shippingAddress = $requestData[$productId][$key][$value['sendto']];
                      $saveValue['customer_id'] = $quote->getCustomerId();
                      $saveValue['delegate_email'] = $shippingAddress['delegate_email'];
                      $saveValue['prefix'] = $shippingAddress['prefix'];
                      $saveValue['firstname'] = $shippingAddress['firstname'];
                      $saveValue['middlename'] = $shippingAddress['middlename'];
                      $saveValue['lastname'] = $shippingAddress['lastname'];
                      $saveValue['suffix'] = $shippingAddress['suffix'];
                      $saveValue['company'] = $shippingAddress['company'];
                      $saveValue['street'] = implode("\n",$shippingAddress['street']);
                      $saveValue['city'] = $shippingAddress['city'];
                      
                      if(isset($shippingAddress['region'])){
                        $saveValue['region'] = $shippingAddress['region'];
                      }
                      if(isset($shippingAddress['region_id'])){
                        $saveValue['region_id'] = $shippingAddress['region_id'];
                      }
                      $saveValue['postcode'] = $shippingAddress['postcode'];
                      $saveValue['country_id'] = $shippingAddress['country_id'];
                      $saveValue['telephone'] = $shippingAddress['telephone'];
                      $saveValue['fax'] = $shippingAddress['fax'];
                      $addressSave = true;
                    }else{

                      $shippingAddress = $this->request->getParam('order_new')['shipping_address'];


                  $saveValue['delegate_email'] = $shippingAddress['delegate_email'];
                  $saveValue['prefix'] = $shippingAddress['prefix'];
                  $saveValue['firstname'] = $shippingAddress['firstname'];
                  $saveValue['middlename'] = $shippingAddress['middlename'];
                  $saveValue['lastname'] = $shippingAddress['lastname'];
                  $saveValue['suffix'] = $shippingAddress['suffix'];
                  $saveValue['company'] = $shippingAddress['company'];
                  $saveValue['street'] = implode("\n",$shippingAddress['street']);
                  $saveValue['city'] = $shippingAddress['city'];
                  
                  if(isset($shippingAddress['region'])){
                    $saveValue['region'] = $shippingAddress['region'];
                  }

                  if(isset($shippingAddress['region_id'])){
                    $saveValue['region_id'] = $shippingAddress['region_id'];
                  }
                  
                  $saveValue['postcode'] = $shippingAddress['postcode'];
                  $saveValue['country_id'] = $shippingAddress['country_id'];
                  $saveValue['telephone'] = $shippingAddress['telephone'];
                  $saveValue['fax'] = $shippingAddress['fax'];
                  $addressSave = true;
                    }
                   

                   }
                 elseif($value['sendto']){
                   $address = $this->addressRepository->getById($value['sendto']);
                    
                   if($address->getCustomAttribute('delegate_email')){

                      $saveValue['delegate_email'] = $address->getCustomAttribute('delegate_email')->getValue();

                   }
                    
                    $saveValue['customer_address_id'] = $address->getId();
                    $saveValue['customer_id'] = $quote->getCustomerId();
                    
                    $saveValue['prefix'] =$address->getPrefix();
                    $saveValue['firstname'] = $address->getFirstname();
                    $saveValue['middlename'] = $address->getMiddlename();
                    $saveValue['lastname'] = $address->getLastname();
                    $saveValue['suffix'] = $address->getSuffix();
                    $saveValue['company'] = $address->getCompany();
                    
                    $saveValue['street'] = implode("\n", $address->getStreet());
                    $saveValue['city'] = $address->getCity();
                    
                   $saveValue['region'] = $address->getRegion()->getRegion();
                   
                    $saveValue['region_id'] = $address->getRegionId();
                    
                    $saveValue['postcode'] = $address->getPostcode();
                    $saveValue['country_id'] = $address->getCountryId();
                    $saveValue['telephone'] = $address->getTelephone();
                    $saveValue['fax'] = $address->getFax();
                    

                 }else{
                  
                  $shippingAddress = $this->request->getParam('order_new')['shipping_address'];


                  $saveValue['delegate_email'] = $shippingAddress['delegate_email'];
                  $saveValue['prefix'] = $shippingAddress['prefix'];
                  $saveValue['firstname'] = $shippingAddress['firstname'];
                  $saveValue['middlename'] = $shippingAddress['middlename'];
                  $saveValue['lastname'] = $shippingAddress['lastname'];
                  $saveValue['suffix'] = $shippingAddress['suffix'];
                  $saveValue['company'] = $shippingAddress['company'];
                  $saveValue['street'] = implode("\n",$shippingAddress['street']);
                  $saveValue['city'] = $shippingAddress['city'];
                  
                  if(isset($shippingAddress['region'])){
                    $saveValue['region'] = $shippingAddress['region'];
                  }
                  if(isset($shippingAddress['region_id'])){
                    $saveValue['region_id'] = $shippingAddress['region_id'];
                  }
                  $saveValue['postcode'] = $shippingAddress['postcode'];
                  $saveValue['country_id'] = $shippingAddress['country_id'];
                  $saveValue['telephone'] = $shippingAddress['telephone'];
                  $saveValue['fax'] = $shippingAddress['fax'];
                  $saveValue['customer_id'] = $quote->getCustomerId();
                  $addressSave = true;
                 }
              //   print_r($saveValue);exit();

              if($addressSave){

                if(isset($saveValue['region_id'])){
                  $region = $this->regFactory->create();
                  $region->load($saveValue['region_id']);
                  $regionId = $region->getRegionId();
              }
              
      
                  if(!isset($regionId)){
                      $region = $this->regionFactory->create()->setRegion($saveValue['region']);
                  }
      
                  unset($saveValue['region']);

                $address = $this->addressDataFactory->create(['data' => $saveValue])->setCustomerId($quote->getCustomerId());
                
                if(isset($regionId)){
                  $address->setRegionId($regionId);
                }else{
                    $address->setRegion($region);
                }
                $address->setCustomAttribute('delegate_email', $saveValue['delegate_email']); 
                $addressId = $this->addressRepository->save($address);
                $saveValue['customer_address_id'] =  $address->getId();
              }
                    
                   

                $saveValue['quote_id'] = $quote->getId();
                $saveValue['product_id'] = $productId;
                $saveValue['item_key'] = $key;
                $saveValue['qty'] = $value['qty'];
                $saveValue['save_in_address_book'] = 1;
                $saveValue['address_type'] = 'shipping';
                $saveValue['email'] = 'email';
                    

  //print_r($saveValue);exit();
                                 
            $multishippingAddress->setData($saveValue)->save();
                }
            }


        }else{
          $quote->setIsMultiDelegate(0);
        }
        return $this;
    }
}
