<?php

namespace Expedux\Sales\Plugin\Model\ResourceModel;

use Magento\Sales\Model\ResourceModel\Order\Handler\State;
use Magento\Sales\Model\Order;

class OrderHandlerStatePlugin
{

    /**
     * Plugin method to intersect the status change, whenever a order with virtual products (that cannot be changed) is set to complete instead of processing.
     *
     * @param State $subject
     * @param callable $proceed
     * @param Order $order
     * @return State
     */
    public function aroundCheck(State $subject, callable $proceed, Order $order)
    {
       
        // $currentState = $order->getState();
        // $currentStatus = $order->getStatus();

        $oldState = $order->getOrigData('state');
        $oldStatus = $order->getOrigData('status');

        $statusSet = false;

        if($order->getIsInProcess()){
            if($oldState && $oldStatus){
                $order->setState($oldState)
                ->setStatus($oldStatus);
                $statusSet = true;
            }
        }

        if (!$statusSet) {
            $proceed($order);
        }
        
        return $subject;
    }

}
