<?php
namespace Expedux\Sales\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function upgrade(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $installer = $setup;

        $installer->startSetup();


        if (version_compare($context->getVersion(), '1.0.2', '<')) {

            $eavTable1 = $installer->getTable('sales_order');
    
            $columns = [
                'is_multi_delegate' => [
                    'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                    'nullable' => true,
                    'default' => NULL,
                    'length' => 11,
                    'comment' => 'Is Multi Delegate'
                ]
            ];
    
            $connection = $installer->getConnection();
    
            foreach($columns as $name => $definition) {
                $connection->addColumn($eavTable1, $name, $definition);
            }

        }

       if (version_compare($context->getVersion(), '1.0.1', '<')) {

            $eavTable1 = $installer->getTable('quote');
    
            $columns = [
                'is_multi_delegate' => [
                    'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                    'nullable' => true,
                    'default' => NULL,
                    'length' => 11,
                    'comment' => 'Is Multi Delegate'
                ]
            ];
    
            $connection = $installer->getConnection();
    
            foreach($columns as $name => $definition) {
                $connection->addColumn($eavTable1, $name, $definition);
            }

        }
            $installer->endSetup();
    }

}