<?php
namespace Expedux\Sales\Ui\Component\Listing\Column;
 
use \Magento\Sales\Api\OrderRepositoryInterface;
use \Magento\Framework\View\Element\UiComponent\ContextInterface;
use \Magento\Framework\View\Element\UiComponentFactory;
use \Magento\Ui\Component\Listing\Columns\Column;

 
class InvoiceId extends Column
{
 
    protected $_orderRepository;
    protected $_searchCriteria;
    protected $_customfactory;
 
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        OrderRepositoryInterface $orderRepository,
        array $components = [], array $data = [])
    {
        $this->_orderRepository = $orderRepository;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }
 
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            
            foreach ($dataSource['data']['items'] as & $item) {
                $order  = $this->_orderRepository->get($item["entity_id"]);
                $invoice_ids = [];
                foreach ($order->getInvoiceCollection() as $invoice)
                {
                    $invoice_ids[] = $invoice->getIncrementId();
                }
                $invoice_id = '';
                if(count($invoice_ids)>0){
                    $invoice_id = implode(', ', $invoice_ids);
                }

                $item[$this->getData('name')] = $invoice_id;
            }
        }
        return $dataSource;
    }
}