<?php
namespace Expedux\Sales\Ui\Component\Listing\Column;
 
use \Magento\Sales\Api\OrderRepositoryInterface;
use \Magento\Framework\View\Element\UiComponent\ContextInterface;
use \Magento\Framework\View\Element\UiComponentFactory;
use \Magento\Ui\Component\Listing\Columns\Column;

 
class Sku extends Column
{
 
    protected $_orderRepository;
    protected $_searchCriteria;
    protected $_customfactory;
 
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        OrderRepositoryInterface $orderRepository,
        array $components = [], array $data = [])
    {
        $this->_orderRepository = $orderRepository;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }
 
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            
            foreach ($dataSource['data']['items'] as & $item) {
                $order  = $this->_orderRepository->get($item["entity_id"]);
               // $order = $this->order->load(11268);

                $skus = [];

                foreach ($order->getAllItems() as $orderItem)
                {
                    if ($orderItem->getParentItem()) {
                        continue;
                    }
                    $skus[] = $orderItem->getSku();
                }
               $sku = '';
                if(count($skus)>0){
                    $sku = implode(', ', $skus);
                }

                $item[$this->getData('name')] = $sku;
            }
        }
        return $dataSource;
    }
}