<?php
/**
 * Copyright © 2016 AionNext Ltd. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magestore\Bannerslider\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\DB\Ddl\Table;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface {
	/**
	 * Upgrades DB schema, add sort_order
	 *
	 * @param SchemaSetupInterface $setup
	 * @param ModuleContextInterface $context
	 *
	 * @return void
	 */
	public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
        $setup->startSetup();

      
		if ( version_compare( $context->getVersion(), '1.7.3' ) < 0 ) {
			
			$tableName = $setup->getTable('magestore_bannerslider_banner');
			if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'hover_image' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'nullable' => true,
                        'length' => 255,
                        'comment' => 'Hover Banner Image',
                        'after' => 'image'
                    ],
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }
            }
		}
		$setup->endSetup();
	}
}
