<?php
namespace Rootsbridge\Brands\Block\Adminhtml\Upload\Edit\Tab;



class Main extends \Magento\Backend\Block\Widget\Form\Generic implements \Magento\Backend\Block\Widget\Tab\TabInterface
{
     /**
     * @var \Magento\Cms\Model\Wysiwyg\Config
     */
    protected $_wysiwygConfig;
    /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $store;

    /**
    * @var \Webspeaks\ProductsGrid\Helper\Data $helper
    */
    protected $helper;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Rootsbridge\Brands\Helper\Data $helper,
        \Rootsbridge\Brands\Model\Status $status,
        \Magento\Catalog\Model\Product\Attribute\Repository $productAttributeRepository,
   
        array $data = []
    ) {
        $this->_productAttributeRepository = $productAttributeRepository;
        $this->_wysiwygConfig = $wysiwygConfig;
        $this->helper = $helper;
        $this->_status = $status;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Prepare form
     *
     * @return $this
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function _prepareForm()
    {
        $manufacturerOptions = $this->_productAttributeRepository->get('manufacturer')->getOptions();       
    $values = array();
    foreach ($manufacturerOptions as $manufacturerOption) { 
       //$manufacturerOption->getValue();  // Value
        $values[$manufacturerOption->getValue()] = $manufacturerOption->getLabel();  // Label

    }
	natcasesort($values);

        /* @var $model \Webspeaks\ProductsGrid\Model\Contact */
        $model = $this->_coreRegistry->registry('rootsbridge_upload');

        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $isElementDisabled = false;
        $form->setHtmlIdPrefix('contact_');

        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('Brand Information')]);

        if ($model->getId()) {
            $fieldset->addField('id', 'hidden', ['name' => 'id']);
        }

        $fieldset->addField(
            'title',
            'text',
            [
                'name' => 'title',
                'label' => __('Title'),
                'title' => __('Title'),
                'required' => true,
            ]
        );
        

        $fieldset->addField(
            'file',
            'image',
            [
                'name' => 'file',
                'label' => __('File'),
                'title' => __('File'),
                'required' => true,
                
            ]
        );

        $fieldset->addField(
            'hover_image',
            'image',
            [
                'name' => 'hover_image',
                'label' => __('Hover File'),
                'title' => __('Hover File'),
                'required' => false,
                
            ]
        );

        $fieldset->addField(
            'image_alt',
            'text',
            [
                'name' => 'image_alt',
                'label' => __('Alt Text'),
                'title' => __('Alt Text'),
            ]
        );

        $fieldset->addField(
            'click_url',
            'text',
            [
                'name' => 'click_url',
                'label' => __('URL'),
                'title' => __('URL'),            ]
        );
        
        
        $fieldset->addField(
            'status',
            'select',
            [
                'label' => __('Status'),
                'title' => __('Status'),
                'name' => 'status',
                'required' => true,
                'options' => $this->_status->getOptionArray(),
                'disabled' => $isElementDisabled
            ]
        );


        


        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Prepare label for tab
     *
     * @return \Magento\Framework\Phrase
     */
    
    public function getTabLabel()
    {
        return __('Select Brands');
    }

    /**
     * Prepare title for tab
     *
     * @return \Magento\Framework\Phrase
     */
    public function getTabTitle()
    {
        return __('Select Brands');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
