<?php
namespace Rootsbridge\Brands\Block\Product;

class Manufacturer extends \Magento\Framework\View\Element\Template
{
	protected $uploadFactory;
	public function __construct(
		\Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Rootsbridge\Brands\Model\UploadFactory $uploadFactory
	)
	{
        $this->_registry = $registry;
        $this->uploadFactory = $uploadFactory;
		parent::__construct($context);
	}

	public function getManufacturer(){
        $currentProduct = $this->_registry->registry('current_product');
       
        $attributes = $currentProduct->getAttributes();
        $manufacturer = $attributes['manufacturer']->getFrontend()->getvalue($currentProduct);
        $attr = $currentProduct->getResource()->getAttribute('manufacturer');
        $model = $this->uploadFactory->create();
        $modelCollection  =  $model->getCollection();
        if ($attr->usesSource()) { 
            $option_id = $attr->getSource()->getOptionId($manufacturer);
            $modelCollection->addFieldToFilter('manufacturer',$option_id);
            // if($modelCollection->getSize()){
            //     echo $modelCollection->getFirstItem()->getId();
            //     die("enters");
            // }
            
        }                  
        return $modelCollection;
    }
    
    public function getBrands(){
      
        $model = $this->uploadFactory->create();
        $modelCollection  =  $model->getCollection();
        $modelCollection->addFieldToFilter('status',['eq' => 'Enable']);
        $modelCollection->setOrder('title','ASC'); 
                    
        return $modelCollection;
	}
}
