<?php
/**
 * Webkul Software.
 *
 * PHP version 7.0+
 *
 * @category  Webkul
 * @package   Webkul_Pos
 * @author    Webkul <support@webkul.com>
 * @copyright 2010-2018 Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html ASL Licence
 * @link      https://store.webkul.com/license.html
 */

namespace Rootsbridge\Brands\Model\Source;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\Data\OptionSourceInterface;

class ManufacturerOption implements OptionSourceInterface
{
    public function getOptionArray()
    {   
        $collection = ObjectManager::getInstance()->create("Magento\Authorization\Model\ResourceModel\Role\Collection");
        // $userModel = ObjectManager::getInstance()->create('Magento\User\Model\User');
        // $collection->addFieldToFilter('role_name', 'manager');
        $eavConfig = ObjectManager::getInstance()->create('\Magento\Eav\Model\Config');
        $attribute = $eavConfig->getAttribute('catalog_product', 'manufacturer');
        $options = $attribute->getSource()->getAllOptions();

        $optionsExists = array();

        foreach($options as $option) {
            $optionsExists[$option['value']] = $option['label'];
        }
        return $optionsExists;
    }

    public function toOptionArray()
    {
        
        $res = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $res[] = ['value' => $index, 'label' => $value];
        }
        return $res;
    }
}
