<?php



namespace Rootsbridge\Brands\Model;
use Magento\Framework\DataObject\IdentityInterface;

class Upload extends \Magento\Framework\Model\AbstractModel implements IdentityInterface
{
    /**
     * CMS page cache tag
     */
    const CACHE_TAG = 'ws_products_grid';

    /**
     * @var string
     */
    protected $_cacheTag = 'ws_products_grid';

    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'ws_products_grid';

    /**
     * Initialize resource model
     *
     * @return void
     */
   
    protected $_staffCollectionFactory;

   
    protected $_storeViewId = null;

    
    protected $_staffFactory;

   
    protected $_formFieldHtmlIdPrefix = 'page_';

    
    protected $_storeManager;

   
    protected $_monolog;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Rootsbridge\Brands\Model\ResourceModel\Upload $resource,
        \Rootsbridge\Brands\Model\ResourceModel\Upload\Collection $resourceCollection,
        \Rootsbridge\Brands\Model\UploadFactory $staffFactory,
        
        \Rootsbridge\Brands\Model\ResourceModel\Upload\CollectionFactory $staffCollectionFactory,
    
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Logger\Monolog $monolog
    ) {
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection
        );
        $this->_staffFactory = $staffFactory;
       
      
        $this->_storeManager = $storeManager;
        $this->_staffCollectionFactory = $staffCollectionFactory;
        $this->_init('Rootsbridge\Brands\Model\ResourceModel\Upload');
        $this->_monolog = $monolog;

        if ($storeViewId = $this->_storeManager->getStore()->getId()) {
            $this->_storeViewId = $storeViewId;
        }
        
    }
    protected function _construct()
    {
        $this->_init('Rootsbridge\Brands\Model\ResourceModel\Upload');
    }

    /**
     * Return unique ID(s) for each object in system
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    public function getProducts(\Rootsbridge\Brands\Model\Upload $object)
    {
        $tbl = $this->getResource()->getTable(\Rootsbridge\Brands\Model\ResourceModel\Upload::TBL_ATT_PRODUCT);
        $select = $this->getResource()->getConnection()->select()->from(
            $tbl,
            ['product_id']
        )
        ->where(
            'id = ?',
            (int)$object->getId()
        );
        return $this->getResource()->getConnection()->fetchCol($select);
    }

   

    
}
