<?php
/**
 * @author      Vladimir Popov
 * @copyright   Copyright © 2017 Vladimir Popov. All rights reserved.
 */

namespace Rootsbridge\Brands\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;

use Magento\Framework\DB\Adapter\AdapterInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup; 

        $installer->startSetup();

        if (version_compare($context->getVersion(), '1.0.2', '<')) {
          
                $installer->getConnection()->addColumn(
                    $installer->getTable('rb_brands'),
                    'hover_image',
                    [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'length' => 255,
                        'nullable' => true,
                        'comment' => 'Hover Image'
                    ]
                );
            }


        if (version_compare($context->getVersion(), '1.0.1', '<')) {
          
            
            $installer->getConnection()->addColumn(
                $installer->getTable('rb_brands'),
                'click_url',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'length' => 255,
                    'nullable' => true,
                    'comment' => 'Click_url'
                ]
    
            );
            $installer->getConnection()->addColumn(
                $installer->getTable('rb_brands'),
                'image_alt',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'length' => 255,
                    'nullable' => true,
                    'comment' => 'Image_alt'
                ]
            );

                   

            }

            $installer->endSetup();
    }
}