<?php
/**
 * @author      Vladimir Popov
 * @copyright   Copyright © 2018 Vladimir Popov. All rights reserved.
 */

namespace VladimirPopov\WebForms\Controller\Result;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Filesystem\DirectoryList;


class Pdf extends Action
{
    protected $session;

    protected $_fileFactory;

    public function __construct(
        Context $context,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory
    )
    {
        $this->_fileFactory = $fileFactory;

        parent::__construct($context);
    }

    public function execute()
    {
        $this->session = $this->_objectManager->get('Magento\Customer\Model\Session');

        // init model and delete
        $hash = $this->getRequest()->getParam('hash');
        if($hash) {
            $id = $this->session->getData($hash);
            if($id) {
                /** @var \VladimirPopov\WebForms\Model\Result $model */
                $model = $this->_objectManager->create('VladimirPopov\WebForms\Model\Result')->load($id);
                if (@class_exists('\Mpdf\Mpdf')) {
                    $mpdf = @new \Mpdf\Mpdf(['mode' => 'utf-8']);
                    @$mpdf->WriteHTML($model->toPrintableHtml());
                    return $this->_fileFactory->create(
                        $model->getPdfFilename(),
                        @$mpdf->Output('', 'S'),
                        DirectoryList::TMP
                    );
                }
            }
        }
        /** @var \Magento\Framework\Controller\Result\Forward $resultForward */
        $resultForward = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);
        $resultForward->forward('noroute');
        return $resultForward;
    }
}
