<?php
/**
 * @author      Vladimir Popov
 * @copyright   Copyright © 2017 Vladimir Popov. All rights reserved.
 */

namespace VladimirPopov\WebForms\Model\ResourceModel;
use VladimirPopov\WebForms\Model\ResourceModel\Field\Collection;
use VladimirPopov\WebForms\Model\ResourceModel\Field\CollectionFactory;

/**
 * Fieldset resource model
 *
 */
class Fieldset extends AbstractResource
{
    const ENTITY_TYPE = 'fieldset';

    public function getEntityType(){
        return self::ENTITY_TYPE;
    }

     /**
     * Name of scope for error messages
     *
     * @var string
     */
    protected $_messagesScope = 'webforms/session';

    protected $_fieldCollectionFactory;

    protected $_formFactory;

    public function __construct(
        \VladimirPopov\WebForms\Model\ResourceModel\Field\CollectionFactory $fieldCollectionFactory,
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \VladimirPopov\WebForms\Model\StoreFactory $storeFactory,
        \VladimirPopov\WebForms\Model\FormFactory $formFactory,
        \Magento\Framework\Stdlib\DateTime $dateTime,
        $connectionName = null
    ) {
        parent::__construct($context, $date, $storeFactory, $dateTime, $connectionName);

        $this->_fieldCollectionFactory = $fieldCollectionFactory;
        $this->_formFactory = $formFactory;
    }

    /**
     * Initialize resource model
     * Get tablename from config
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('webforms_fieldsets', 'id');
    }

    /**
     * Set error messages scope
     *
     * @param string $scope
     * @return void
     */
    public function setMessagesScope($scope)
    {
        $this->_messagesScope = $scope;
    }

    protected function _beforeDelete(\Magento\Framework\Model\AbstractModel $object){
        //set fields fieldset_id to null
        $fields = $this->_fieldCollectionFactory->create()->addFilter('fieldset_id',$object->getId());
        foreach($fields as $field){
            $field->setFieldsetId(0)->save();
        }

        return parent::_beforeDelete($object);
    }

    protected function _afterDelete(\Magento\Framework\Model\AbstractModel $object)
    {
        //update logic rules
        $webform = $this->_formFactory->create()->load($object->getData('webform_id'));
        $logic_collection = $webform->getLogic();
        foreach ($logic_collection as $logic_rule){
            $logic_rule->save();
        }

        return parent::_afterDelete($object); // TODO: Change the autogenerated stub
    }

    protected function _beforeSave(\Magento\Framework\Model\AbstractModel $object)
    {
        if ($object->isObjectNew() && !$object->hasCreatedTime()) {
            $object->setCreatedTime($this->_date->gmtDate());
        }

        $object->setUpdateTime($this->_date->gmtDate());

        parent::_beforeSave($object);
    }

    protected function _afterLoad(\Magento\Framework\Model\AbstractModel $object)
    {
        return parent::_afterLoad($object);
    }
}
