define(['prototype'], function () {
    Varien.DateElement = Class.create();
    Varien.DateElement.prototype = {
        initialize: function (type, content, required, format) {
            if (type == 'id') {
                // id prefix
                this.day = $(content + 'day');
                this.month = $(content + 'month');
                this.year = $(content + 'year');
                this.full = $(content + 'full');
                this.advice = $(content + 'date-advice');
            } else if (type == 'container') {
                // content must be container with data
                this.day = content.day;
                this.month = content.month;
                this.year = content.year;
                this.full = content.full;
                this.advice = content.advice;
            } else {
                return;
            }

            this.required = required;
            this.format = format;

            this.day.addClassName('validate-custom');
            this.day.validate = this.validate.bind(this);
            this.month.addClassName('validate-custom');
            this.month.validate = this.validate.bind(this);
            this.year.addClassName('validate-custom');
            this.year.validate = this.validate.bind(this);

            this.setDateRange(false, false);
            this.year.setAttribute('autocomplete', 'off');

            this.advice.hide();
        },
        validate: function () {
            var error = false,
                day = parseInt(this.day.value, 10) || 0,
                month = parseInt(this.month.value, 10) || 0,
                year = parseInt(this.year.value, 10) || 0;

            if (this.day.value.strip().empty() &&
                this.month.value.strip().empty() &&
                this.year.value.strip().empty()
            ) {
                if (this.required) {
                    error = 'Please enter a date.';
                } else {
                    this.full.value = '';
                }
            } else if (!day || !month || !year) {
                error = 'Please enter a valid full date.';
            } else {
                var date = new Date,
                    countDaysInMonth = 0,
                    errorType = null;

                date.setYear(year);
                date.setMonth(month - 1);
                date.setDate(32);
                countDaysInMonth = 32 - date.getDate();

                if (!countDaysInMonth || countDaysInMonth > 31) countDaysInMonth = 31;

                if (day < 1 || day > countDaysInMonth) {
                    errorType = 'day';
                    error = 'Please enter a valid day (1-%1).';
                } else if (month < 1 || month > 12) {
                    errorType = 'month';
                    error = 'Please enter a valid month (1-12).';
                } else {
                    if (day % 10 == day) this.day.value = '0' + day;

                    if (month % 10 == month) this.month.value = '0' + month;
                    this.full.value = this.format.replace(/%[mb]/i, this.month.value).replace(/%[de]/i, this.day.value).replace(/%y/i, this.year.value);
                    var testFull = this.month.value + '/' + this.day.value + '/' + this.year.value;
                    var test = new Date(testFull);

                    if (isNaN(test)) {
                        error = 'Please enter a valid date.';
                    } else {
                        this.setFullDate(test);
                    }
                }
                var valueError = false;

                if (!error && !this.validateData()) {//(year<1900 || year>curyear) {
                    errorType = this.validateDataErrorType;//'year';
                    valueError = this.validateDataErrorText;//'Please enter a valid year (1900-%d).';
                    error = valueError;
                }
            }

            if (error !== false) {
                if (jQuery.mage.__) {
                    error = jQuery.mage.__(error);
                }

                if (!valueError) {
                    this.advice.innerHTML = error.replace('%1', countDaysInMonth);
                } else {
                    this.advice.innerHTML = this.errorTextModifier(error);
                }
                this.advice.show();

                return false;
            }

            // fixing elements class
            this.day.removeClassName('validation-failed');
            this.month.removeClassName('validation-failed');
            this.year.removeClassName('validation-failed');

            this.advice.hide();

            return true;
        },
        validateData: function () {
            var year = this.fullDate.getFullYear();
            var date = new Date;

            this.curyear = date.getFullYear();

            return year >= 1900 && year <= this.curyear;
        },
        validateDataErrorType: 'year',
        validateDataErrorText: 'Please enter a valid year (1900-%1).',
        errorTextModifier: function (text) {
            return text.replace('%1', this.curyear);
        },
        setDateRange: function (minDate, maxDate) {
            this.minDate = minDate;
            this.maxDate = maxDate;
        },
        setFullDate: function (date) {
            this.fullDate = date;
        }
    };

    Varien.DOB = Class.create();
    Varien.DOB.prototype = {
        initialize: function (selector, required, format) {
            var el = $$(selector)[0];
            var container = {};

            container.day = Element.select(el, '.dob-day input')[0];
            container.month = Element.select(el, '.dob-month input')[0];
            container.year = Element.select(el, '.dob-year input')[0];
            container.full = Element.select(el, '.dob-full input')[0];
            container.advice = Element.select(el, '.validation-advice')[0];

            new Varien.DateElement('container', container, required, format);
        }
    };

    return Varien.DOB;
});