define([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'mage/mage',
    'jquery/ui'
], function($,modal) {
    "use strict";
    $.widget('expedux.productpopup', {
        _create: function() {
            var options = {
                type: 'popup',
                responsive: true,
                innerScroll: true,
                buttons: false,
                title: '<div>Finance Options – 0% APR</div>',
                modalClass:'finance-popup',
            };
            
            modal(options, $('#finance-popup'));
            var self = this;
            $("#finance-btn").on('click',function(e){
                var price = $('.product-info-price .price-box span.price').text();
                console.log(price)

                price = price.replace('£','');
                price = parseFloat(price.replace(',',''));
                var mon0 = self.financingCalc(price,0.2,0,0);
                var mon3 = self.financingCalc(price,0.2,3,199);
                var mon6 = self.financingCalc(price,0.2,6,199);
                var mon9 = self.financingCalc(price,0.2,9,199);
                var mon11 = self.financingCalc(price,0.2,11,199);
            
                  var formatter = new Intl.NumberFormat('en-GB', {style: 'currency',currency: 'GBP',});
                $(".fp-total").text(formatter.format(mon0));
                $(".pay .mon3").text(formatter.format(mon3));
                $(".pay .mon6").text(formatter.format(mon6));
                $(".pay .mon9").text(formatter.format(mon9));
                $(".pay .mon11").text(formatter.format(mon11));

                $("#finance-popup").modal("openModal");

            });
        },
         financingCalc: function(price,vat,mon,deposit){
            price = parseFloat(price);
            vat = parseFloat(vat);
            mon = parseInt(mon);
            deposit = parseFloat(deposit);
            if(price > 0){
              price = (price*vat)+price;
              price = price-deposit;
              if(mon > 0) price = price/mon;
            }
            return price.toFixed(2);
          },
    });
    return $.expedux.productpopup;
});